/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.cassandra2.state;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.elasticsoftware.elasticactors.ShardKey;
import org.elasticsoftware.elasticactors.cassandra.common.state.PersistentActorUpdateEvent;
import org.elasticsoftware.elasticactors.cassandra2.util.ExecutionUtils;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;
import org.elasticsoftware.elasticactors.messaging.MessageHandlerEventListener;
import org.elasticsoftware.elasticactors.serialization.Deserializer;
import org.elasticsoftware.elasticactors.serialization.Serializer;
import org.elasticsoftware.elasticactors.state.PersistentActor;
import org.elasticsoftware.elasticactors.state.PersistentActorRepository;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundEvent;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CassandraPersistentActorRepository
implements PersistentActorRepository {
    private static final Logger logger = LoggerFactory.getLogger(CassandraPersistentActorRepository.class);
    private final String clusterName;
    private final ThreadBoundExecutor asyncUpdateExecutor;
    private final long readExecutionThresholdMillis;
    private final Session cassandraSession;
    private final PreparedStatement selectStatement;
    private final Deserializer<ByteBuffer, PersistentActor> deserializer;
    private final Serializer<PersistentActor, ByteBuffer> serializer;

    public CassandraPersistentActorRepository(Session cassandraSession, String clusterName, ThreadBoundExecutor asyncUpdateExecutor, Serializer serializer, Deserializer deserializer) {
        this(cassandraSession, clusterName, asyncUpdateExecutor, serializer, deserializer, 200L);
    }

    public CassandraPersistentActorRepository(Session cassandraSession, String clusterName, ThreadBoundExecutor asyncUpdateExecutor, Serializer serializer, Deserializer deserializer, long readExecutionThresholdMillis) {
        this.cassandraSession = cassandraSession;
        this.selectStatement = cassandraSession.prepare("select value from \"PersistentActors\" where key = ? and key2 = ? AND column1 = ?");
        this.clusterName = clusterName;
        this.asyncUpdateExecutor = asyncUpdateExecutor;
        this.readExecutionThresholdMillis = readExecutionThresholdMillis;
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    public boolean contains(ShardKey shard, String actorId) {
        return this.internalGet(shard, actorId) != null;
    }

    public void update(ShardKey shard, PersistentActor persistentActor) throws IOException {
        ByteBuffer serializedActorBytes = (ByteBuffer)this.serializer.serialize((Object)persistentActor);
        this.asyncUpdateExecutor.execute((ThreadBoundEvent)new PersistentActorUpdateEvent(this.createKey(shard), shard, persistentActor.getSelf().getActorId(), serializedActorBytes, null, null));
    }

    public void updateAsync(ShardKey shard, PersistentActor persistentActor, InternalMessage message, MessageHandlerEventListener messageHandlerEventListener) throws IOException {
        ByteBuffer serializedActorBytes = (ByteBuffer)this.serializer.serialize((Object)persistentActor);
        this.asyncUpdateExecutor.execute((ThreadBoundEvent)new PersistentActorUpdateEvent(this.createKey(shard), shard, persistentActor.getSelf().getActorId(), serializedActorBytes, message, messageHandlerEventListener));
    }

    public void delete(ShardKey shard, String actorId) {
        this.asyncUpdateExecutor.execute((ThreadBoundEvent)new PersistentActorUpdateEvent(this.createKey(shard), shard, actorId, null, null, null));
    }

    public PersistentActor<ShardKey> get(ShardKey shard, String actorId) throws IOException {
        Row resultRow = this.internalGet(shard, actorId);
        if (resultRow == null || resultRow.getColumnDefinitions().size() == 0) {
            return null;
        }
        return (PersistentActor)this.deserializer.deserialize((Object)resultRow.getBytes(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Row internalGet(ShardKey shard, String actorId) {
        Row row;
        block3: {
            long duration;
            long startTime = System.nanoTime();
            try {
                ResultSet resultSet = ExecutionUtils.executeWithRetry(this.cassandraSession, (Statement)this.selectStatement.bind(new Object[]{this.clusterName, shard.toString(), actorId}), logger);
                row = resultSet.one();
                duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
                if (duration <= this.readExecutionThresholdMillis) break block3;
            }
            catch (Throwable throwable) {
                long duration2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
                if (duration2 > this.readExecutionThresholdMillis) {
                    logger.warn("Cassandra read operation took {} msecs for actorId [{}] on shard [{}]", new Object[]{duration2, actorId, shard});
                }
                throw throwable;
            }
            logger.warn("Cassandra read operation took {} msecs for actorId [{}] on shard [{}]", new Object[]{duration, actorId, shard});
        }
        return row;
    }

    private String[] createKey(ShardKey shardKey) {
        String[] composite = new String[]{this.clusterName, shardKey.toString()};
        return composite;
    }
}

