/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.cassandra2.util;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.BootstrappingException;
import com.datastax.driver.core.exceptions.ConnectionException;
import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.OverloadedException;
import com.datastax.driver.core.exceptions.QueryConsistencyException;
import com.datastax.driver.core.exceptions.UnavailableException;
import java.net.InetAddress;
import org.slf4j.Logger;

public final class ExecutionUtils {
    private ExecutionUtils() {
    }

    public static ResultSet executeWithRetry(Session cassandraSession, Statement statement, Logger logger) {
        int attempts = 0;
        Object latestException = null;
        while (attempts++ <= 3) {
            try {
                return cassandraSession.execute(statement);
            }
            catch (BootstrappingException | ConnectionException | OverloadedException | QueryConsistencyException e) {
                logger.warn("{} on node {} while executing statement, retry attempt {}", new Object[]{e.getClass().getSimpleName(), ((CoordinatorException)e).getHost(), attempts});
                latestException = e;
            }
            catch (UnavailableException e) {
                logger.error("node {} is reporting not enough replicas available, will not retry", (Object)e.getHost());
                throw e;
            }
            catch (RuntimeException e) {
                InetAddress node = e instanceof CoordinatorException ? ((CoordinatorException)e).getHost() : null;
                logger.error("{} on node {} while executing statement, will not retry", (Object)e.getClass().getSimpleName(), (Object)node);
                throw e;
            }
        }
        logger.error("Failed to execute Statement after {} attempts, throwing latest exception {}", (Object)attempts, (Object)latestException.getClass().getSimpleName());
        throw latestException;
    }
}

