/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.configuration;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.LoggingRetryPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import jakarta.annotation.PreDestroy;
import java.util.Set;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class CassandraSessionManager {
    private final Session cassandraSession;

    public CassandraSessionManager(Environment env) {
        String cassandraHosts = env.getProperty("ea.cassandra.hosts", "localhost:9042");
        String cassandraClusterName = env.getProperty("ea.cassandra.cluster", "ElasticActorsCluster");
        String cassandraKeyspaceName = env.getProperty("ea.cassandra.keyspace", "\"ElasticActors\"");
        Integer cassandraPort = (Integer)env.getProperty("ea.cassandra.port", Integer.class, (Object)9042);
        Set hostSet = StringUtils.commaDelimitedListToSet((String)cassandraHosts);
        String[] contactPoints = new String[hostSet.size()];
        int i = 0;
        for (String host : hostSet) {
            contactPoints[i] = host.contains(":") ? host.substring(0, host.indexOf(":")) : host;
            ++i;
        }
        PoolingOptions poolingOptions = new PoolingOptions();
        poolingOptions.setHeartbeatIntervalSeconds(60);
        poolingOptions.setConnectionsPerHost(HostDistance.LOCAL, 2, ((Integer)env.getProperty("ea.cassandra.maxActive", Integer.class, (Object)(Runtime.getRuntime().availableProcessors() * 3))).intValue());
        poolingOptions.setPoolTimeoutMillis(2000);
        Cluster cassandraCluster = Cluster.builder().withClusterName(cassandraClusterName).addContactPoints(contactPoints).withPort(cassandraPort.intValue()).withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy()).withRetryPolicy((RetryPolicy)new LoggingRetryPolicy((RetryPolicy)DefaultRetryPolicy.INSTANCE)).withPoolingOptions(poolingOptions).withReconnectionPolicy((ReconnectionPolicy)new ConstantReconnectionPolicy((long)((Integer)env.getProperty("ea.cassandra.retryDownedHostsDelayInSeconds", Integer.class, (Object)1) * 1000))).withQueryOptions(new QueryOptions().setConsistencyLevel(ConsistencyLevel.QUORUM)).build();
        this.cassandraSession = cassandraCluster.connect(cassandraKeyspaceName);
    }

    public Session getSession() {
        return this.cassandraSession;
    }

    @PreDestroy
    public void destroy() {
        this.cassandraSession.close();
        this.cassandraSession.getCluster().close();
    }
}

