/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.cassandra4.state;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.elasticsoftware.elasticactors.ShardKey;
import org.elasticsoftware.elasticactors.cassandra.common.state.PersistentActorUpdateEvent;
import org.elasticsoftware.elasticactors.cassandra4.util.ExecutionUtils;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;
import org.elasticsoftware.elasticactors.messaging.MessageHandlerEventListener;
import org.elasticsoftware.elasticactors.serialization.Deserializer;
import org.elasticsoftware.elasticactors.serialization.Serializer;
import org.elasticsoftware.elasticactors.state.PersistentActor;
import org.elasticsoftware.elasticactors.state.PersistentActorRepository;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundEvent;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CassandraPersistentActorRepository
implements PersistentActorRepository {
    private static final Logger logger = LoggerFactory.getLogger(CassandraPersistentActorRepository.class);
    private final String clusterName;
    private final ThreadBoundExecutor asyncUpdateExecutor;
    private final long readExecutionThresholdMillis;
    private final CqlSession cassandraSession;
    private final PreparedStatement selectStatement;
    private final Deserializer<ByteBuffer, PersistentActor> deserializer;
    private final Serializer<PersistentActor, ByteBuffer> serializer;

    public CassandraPersistentActorRepository(CqlSession cassandraSession, String clusterName, ThreadBoundExecutor asyncUpdateExecutor, Serializer serializer, Deserializer deserializer) {
        this(cassandraSession, clusterName, asyncUpdateExecutor, serializer, deserializer, 200L);
    }

    public CassandraPersistentActorRepository(CqlSession cassandraSession, String clusterName, ThreadBoundExecutor asyncUpdateExecutor, Serializer serializer, Deserializer deserializer, long readExecutionThresholdMillis) {
        this.cassandraSession = cassandraSession;
        this.selectStatement = cassandraSession.prepare("select value from \"PersistentActors\" where key = ? and key2 = ? AND column1 = ?");
        this.clusterName = clusterName;
        this.asyncUpdateExecutor = asyncUpdateExecutor;
        this.readExecutionThresholdMillis = readExecutionThresholdMillis;
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    public boolean contains(ShardKey shard, String actorId) {
        return this.internalGet(shard, actorId) != null;
    }

    public void update(ShardKey shard, PersistentActor persistentActor) throws IOException {
        ByteBuffer serializedActorBytes = (ByteBuffer)this.serializer.serialize((Object)persistentActor);
        this.asyncUpdateExecutor.execute((ThreadBoundEvent)new PersistentActorUpdateEvent(this.createKey(shard), shard, persistentActor.getSelf().getActorId(), serializedActorBytes, null, null));
    }

    public void updateAsync(ShardKey shard, PersistentActor persistentActor, InternalMessage message, MessageHandlerEventListener messageHandlerEventListener) throws IOException {
        ByteBuffer serializedActorBytes = (ByteBuffer)this.serializer.serialize((Object)persistentActor);
        this.asyncUpdateExecutor.execute((ThreadBoundEvent)new PersistentActorUpdateEvent(this.createKey(shard), shard, persistentActor.getSelf().getActorId(), serializedActorBytes, message, messageHandlerEventListener));
    }

    public void delete(ShardKey shard, String actorId) {
        this.asyncUpdateExecutor.execute((ThreadBoundEvent)new PersistentActorUpdateEvent(this.createKey(shard), shard, actorId, null, null, null));
    }

    public PersistentActor<ShardKey> get(ShardKey shard, String actorId) throws IOException {
        Row resultRow = this.internalGet(shard, actorId);
        if (resultRow == null || resultRow.getColumnDefinitions().size() == 0) {
            return null;
        }
        return (PersistentActor)this.deserializer.deserialize((Object)resultRow.getByteBuffer(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Row internalGet(ShardKey shard, String actorId) {
        Row row;
        long startTime = System.currentTimeMillis();
        try {
            ResultSet resultSet = ExecutionUtils.executeWithRetry(this.cassandraSession, (Statement)this.selectStatement.bind(new Object[]{this.clusterName, shard.toString(), actorId}), logger);
            row = (Row)resultSet.one();
        }
        catch (Throwable throwable) {
            long endTime = System.currentTimeMillis();
            if (endTime - startTime > this.readExecutionThresholdMillis) {
                logger.warn("Cassandra read operation took {} msecs for actorId [{}] on shard [{}]", new Object[]{endTime - startTime, actorId, shard});
            }
            throw throwable;
        }
        long endTime = System.currentTimeMillis();
        if (endTime - startTime > this.readExecutionThresholdMillis) {
            logger.warn("Cassandra read operation took {} msecs for actorId [{}] on shard [{}]", new Object[]{endTime - startTime, actorId, shard});
        }
        return row;
    }

    private String[] createKey(ShardKey shardKey) {
        String[] composite = new String[]{this.clusterName, shardKey.toString()};
        return composite;
    }
}

