/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.cassandra4.health;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsoftware.elasticactors.health.HealthCheck;
import org.elasticsoftware.elasticactors.health.HealthCheckResult;
import org.springframework.beans.factory.annotation.Autowired;

public class CassandraHealthCheck
implements HealthCheck {
    private final CqlSession cassandraSession;

    @Autowired
    public CassandraHealthCheck(CqlSession cassandraSession) {
        this.cassandraSession = cassandraSession;
    }

    public HealthCheckResult check() {
        if (this.cassandraSession.isClosed()) {
            return HealthCheckResult.unhealthy((String)"Cassandra Session appears to be closed");
        }
        Set connectedHosts = this.cassandraSession.getMetadata().getNodes().values().stream().filter(node -> node.getState().equals((Object)NodeState.UP)).collect(Collectors.toSet());
        if (this.cassandraSession.getMetadata().getNodes().size() - connectedHosts.size() > 1) {
            return HealthCheckResult.unhealthy((String)"Not enough connected hosts to do QUORUM reads and writes");
        }
        return HealthCheckResult.healthy();
    }
}

