/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.cassandra4.util;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.servererrors.BootstrappingException;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.OverloadedException;
import com.datastax.oss.driver.api.core.servererrors.QueryConsistencyException;
import com.datastax.oss.driver.api.core.servererrors.UnavailableException;
import java.util.Optional;
import org.slf4j.Logger;

public final class ExecutionUtils {
    private ExecutionUtils() {
    }

    public static ResultSet executeWithRetry(CqlSession cassandraSession, Statement statement, Logger logger) {
        int attempts = 0;
        Object latestException = null;
        while (attempts++ <= 3) {
            try {
                return cassandraSession.execute(statement);
            }
            catch (BootstrappingException | OverloadedException | QueryConsistencyException e) {
                logger.warn("{} on node {} while executing statement, retry attempt {}", new Object[]{e.getClass().getSimpleName(), Optional.ofNullable(e.getExecutionInfo().getCoordinator()).map(node -> node.getEndPoint().resolve().toString()).orElse("UNKNOWN"), attempts});
                latestException = e;
            }
            catch (UnavailableException e) {
                logger.error("node {} is reporting not enough replicas available, will not retry", (Object)Optional.ofNullable(e.getExecutionInfo().getCoordinator()).map(node -> node.getEndPoint().resolve().toString()).orElse("UNKNOWN"));
                throw e;
            }
            catch (CoordinatorException e) {
                logger.error("{} on node {} while executing statement, will not retry", (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)Optional.ofNullable(e.getExecutionInfo().getCoordinator()).map(node -> node.getEndPoint().resolve().toString()).orElse("UNKNOWN"));
                throw e;
            }
            catch (RuntimeException e) {
                logger.error("{} on node UNKNOWN while executing statement, will not retry", (Object)e.getClass().getSimpleName());
                throw e;
            }
        }
        logger.error("Failed to execute Statement after {} attempts, throwing latest exception {}", (Object)attempts, (Object)latestException.getClass().getSimpleName());
        throw latestException;
    }
}

