/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.configuration;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.elasticsoftware.elasticactors.cassandra.common.serialization.CompressingSerializer;
import org.elasticsoftware.elasticactors.cassandra.common.serialization.DecompressingDeserializer;
import org.elasticsoftware.elasticactors.cassandra4.cluster.CassandraActorSystemEventListenerRepository;
import org.elasticsoftware.elasticactors.cassandra4.cluster.scheduler.CassandraScheduledMessageRepository;
import org.elasticsoftware.elasticactors.cassandra4.health.CassandraHealthCheck;
import org.elasticsoftware.elasticactors.cassandra4.state.CassandraPersistentActorRepository;
import org.elasticsoftware.elasticactors.cassandra4.state.PersistentActorUpdateEventProcessor;
import org.elasticsoftware.elasticactors.cluster.ActorRefFactory;
import org.elasticsoftware.elasticactors.cluster.ActorSystemEventListenerRepository;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystems;
import org.elasticsoftware.elasticactors.cluster.scheduler.ScheduledMessageRepository;
import org.elasticsoftware.elasticactors.serialization.Deserializer;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.elasticsoftware.elasticactors.serialization.Serializer;
import org.elasticsoftware.elasticactors.serialization.internal.ActorRefDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.PersistentActorDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.PersistentActorSerializer;
import org.elasticsoftware.elasticactors.serialization.internal.ScheduledMessageDeserializer;
import org.elasticsoftware.elasticactors.state.PersistentActorRepository;
import org.elasticsoftware.elasticactors.util.concurrent.DaemonThreadFactory;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundEventProcessor;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundExecutor;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundExecutorImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class BackplaneConfiguration {
    @Autowired
    private Environment env;
    @Autowired
    private InternalActorSystems cluster;
    @Autowired
    private ActorRefFactory actorRefFactory;
    private CqlSession cassandraSession;

    @PostConstruct
    public void initialize() {
        String cassandraHosts = this.env.getProperty("ea.cassandra.hosts", "localhost:9042");
        String cassandraKeyspaceName = this.env.getProperty("ea.cassandra.keyspace", "\"ElasticActors\"");
        Integer cassandraPort = (Integer)this.env.getProperty("ea.cassandra.port", Integer.class, (Object)9042);
        Set hostSet = StringUtils.commaDelimitedListToSet((String)cassandraHosts);
        String[] contactPoints = new String[hostSet.size()];
        int i = 0;
        for (String host2 : hostSet) {
            contactPoints[i] = host2.contains(":") ? host2.substring(0, host2.indexOf(":")) : host2;
            ++i;
        }
        List contactPointAddresses = Arrays.stream(contactPoints).map(host -> new InetSocketAddress((String)host, (int)cassandraPort)).collect(Collectors.toList());
        DriverConfigLoader driverConfigLoader = ((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)DriverConfigLoader.programmaticBuilder().withDuration((DriverOption)DefaultDriverOption.HEARTBEAT_INTERVAL, Duration.ofSeconds(60L))).withString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, ConsistencyLevel.QUORUM.name())).withString((DriverOption)DefaultDriverOption.RETRY_POLICY_CLASS, "DefaultRetryPolicy")).withString((DriverOption)DefaultDriverOption.RECONNECTION_POLICY_CLASS, "ConstantReconnectionPolicy")).withDuration((DriverOption)DefaultDriverOption.RECONNECTION_BASE_DELAY, Duration.ofSeconds(((Integer)this.env.getProperty("ea.cassandra.retryDownedHostsDelayInSeconds", Integer.class, (Object)1)).intValue()))).withString((DriverOption)DefaultDriverOption.LOAD_BALANCING_POLICY_CLASS, "DcInferringLoadBalancingPolicy")).build();
        this.cassandraSession = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoints(contactPointAddresses)).withConfigLoader(driverConfigLoader)).withKeyspace(cassandraKeyspaceName)).build();
    }

    @PreDestroy
    public void destroy() {
        this.cassandraSession.close();
    }

    @Bean(name={"asyncUpdateExecutor"}, destroyMethod="shutdown")
    public ThreadBoundExecutor createAsyncUpdateExecutor() {
        int workers = (Integer)this.env.getProperty("ea.asyncUpdateExecutor.workerCount", Integer.class, (Object)(Runtime.getRuntime().availableProcessors() * 3));
        int batchSize = (Integer)this.env.getProperty("ea.asyncUpdateExecutor.batchSize", Integer.class, (Object)20);
        boolean optimizedV1Batches = (Boolean)this.env.getProperty("ea.asyncUpdateExecutor.optimizedV1Batches", Boolean.TYPE, (Object)true);
        return new ThreadBoundExecutorImpl((ThreadBoundEventProcessor)new PersistentActorUpdateEventProcessor(this.cassandraSession, batchSize, optimizedV1Batches), batchSize, (ThreadFactory)new DaemonThreadFactory("UPDATE-EXECUTOR-WORKER"), workers);
    }

    @Bean(name={"persistentActorRepository"})
    public PersistentActorRepository getPersistentActorRepository(@Qualifier(value="asyncUpdateExecutor") ThreadBoundExecutor asyncUpdateExecutor) {
        Integer compressionThreshold = (Integer)this.env.getProperty("ea.persistentActorRepository.compressionThreshold", Integer.class, (Object)512);
        CompressingSerializer serializer = new CompressingSerializer((Serializer)new PersistentActorSerializer((SerializationFrameworks)this.cluster), compressionThreshold.intValue());
        DecompressingDeserializer deserializer = new DecompressingDeserializer((Deserializer)new PersistentActorDeserializer(this.actorRefFactory, this.cluster));
        return new CassandraPersistentActorRepository(this.cassandraSession, this.cluster.getClusterName(), asyncUpdateExecutor, (Serializer)serializer, (Deserializer)deserializer);
    }

    @Bean(name={"scheduledMessageRepository"})
    public ScheduledMessageRepository getScheduledMessageRepository() {
        return new CassandraScheduledMessageRepository(this.cluster.getClusterName(), this.cassandraSession, new ScheduledMessageDeserializer(new ActorRefDeserializer(this.actorRefFactory)));
    }

    @Bean(name={"actorSystemEventListenerRepository"})
    public ActorSystemEventListenerRepository getActorSystemEventListenerRepository() {
        return new CassandraActorSystemEventListenerRepository(this.cluster.getClusterName(), this.cassandraSession);
    }

    @Bean(name={"cassandraHealthCheck"})
    public CassandraHealthCheck getHealthCheck() {
        return new CassandraHealthCheck(this.cassandraSession);
    }
}

