/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.cassandra4.cluster.scheduler;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.elasticsoftware.elasticactors.ShardKey;
import org.elasticsoftware.elasticactors.cassandra4.util.ExecutionUtils;
import org.elasticsoftware.elasticactors.cluster.scheduler.ScheduledMessage;
import org.elasticsoftware.elasticactors.cluster.scheduler.ScheduledMessageKey;
import org.elasticsoftware.elasticactors.cluster.scheduler.ScheduledMessageRepository;
import org.elasticsoftware.elasticactors.serialization.internal.ScheduledMessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.ScheduledMessageSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CassandraScheduledMessageRepository
implements ScheduledMessageRepository {
    private static final Logger logger = LoggerFactory.getLogger(CassandraScheduledMessageRepository.class);
    private final String clusterName;
    private final CqlSession cassandraSession;
    private final PreparedStatement insertStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement selectStatement;
    private final ScheduledMessageDeserializer scheduledMessageDeserializer;

    public CassandraScheduledMessageRepository(String clusterName, CqlSession cassandraSession, ScheduledMessageDeserializer scheduledMessageDeserializer) {
        this.clusterName = clusterName;
        this.cassandraSession = cassandraSession;
        this.scheduledMessageDeserializer = scheduledMessageDeserializer;
        this.insertStatement = cassandraSession.prepare("INSERT INTO \"ScheduledMessages\" (key, key2, column1, column2, value) VALUES (?, ?, ?, ?, ?)");
        this.deleteStatement = cassandraSession.prepare("DELETE FROM \"ScheduledMessages\" WHERE key = ? AND key2 = ? AND column1 = ? AND column2 = ?");
        this.selectStatement = cassandraSession.prepare("SELECT value from \"ScheduledMessages\" WHERE key = ? AND key2 = ?");
    }

    public void create(ShardKey shardKey, ScheduledMessage scheduledMessage) {
        ExecutionUtils.executeWithRetry(this.cassandraSession, (Statement)this.insertStatement.bind(new Object[]{this.clusterName, shardKey.toString(), scheduledMessage.getFireTime(TimeUnit.MILLISECONDS), scheduledMessage.getId(), ByteBuffer.wrap(ScheduledMessageSerializer.get().serialize(scheduledMessage))}), logger);
    }

    public void delete(ShardKey shardKey, ScheduledMessageKey scheduledMessageKey) {
        ExecutionUtils.executeWithRetry(this.cassandraSession, (Statement)this.deleteStatement.bind(new Object[]{this.clusterName, shardKey.toString(), scheduledMessageKey.getFireTime(), scheduledMessageKey.getId()}), logger);
    }

    public List<ScheduledMessage> getAll(ShardKey shardKey) {
        ResultSet resultSet = ExecutionUtils.executeWithRetry(this.cassandraSession, this.selectStatement.bind(new Object[]{this.clusterName, shardKey.toString()}).setPageSize(Integer.MAX_VALUE), logger);
        LinkedList<ScheduledMessage> resultList = new LinkedList<ScheduledMessage>();
        for (Row resultRow : resultSet) {
            for (int i = 0; i < resultRow.getColumnDefinitions().size(); ++i) {
                ByteBuffer resultBuffer = resultRow.getByteBuffer(i);
                try {
                    resultList.add(this.scheduledMessageDeserializer.deserialize(Objects.requireNonNull(resultBuffer)));
                    continue;
                }
                catch (IOException | NullPointerException e) {
                    logger.error("IOException while deserializing ScheduledMessage", (Throwable)e);
                }
            }
        }
        return resultList;
    }
}

