/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.cassandra4.state;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.elasticsoftware.elasticactors.cassandra.common.state.PersistentActorUpdateEvent;
import org.elasticsoftware.elasticactors.cassandra4.util.ExecutionUtils;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PersistentActorUpdateEventProcessor
implements ThreadBoundEventProcessor<PersistentActorUpdateEvent> {
    private static final Logger logger = LoggerFactory.getLogger(PersistentActorUpdateEventProcessor.class);
    public static final String INSERT_QUERY = "INSERT INTO \"PersistentActors\" (key, key2, column1, value) VALUES (?, ?, ?, ?)";
    public static final String DELETE_QUERY = "DELETE FROM \"PersistentActors\" where key = ? AND key2 = ? AND column1 = ?";
    private final CqlSession cassandraSession;
    private final PreparedStatement insertStatement;
    private final PreparedStatement deleteStatement;

    public PersistentActorUpdateEventProcessor(CqlSession cassandraSession) {
        this.cassandraSession = cassandraSession;
        this.insertStatement = cassandraSession.prepare(INSERT_QUERY);
        this.deleteStatement = cassandraSession.prepare(DELETE_QUERY);
    }

    public void process(PersistentActorUpdateEvent event) {
        this.process(Collections.singletonList(event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(List<PersistentActorUpdateEvent> events) {
        block13: {
            Exception executionException = null;
            long startTime = logger.isTraceEnabled() ? System.nanoTime() : 0L;
            try {
                if (events.size() == 1) {
                    PersistentActorUpdateEvent event = events.get(0);
                    BoundStatement boundStatement = event.hasPersistentActorBytes() ? this.insertStatement.bind(new Object[]{event.getRowKey()[0], event.getRowKey()[1], event.getPersistentActorId(), event.getPersistentActorBytes()}) : this.deleteStatement.bind(new Object[]{event.getRowKey()[0], event.getRowKey()[1], event.getPersistentActorId()});
                    ExecutionUtils.executeWithRetry(this.cassandraSession, (Statement)boundStatement, logger);
                } else {
                    this.executeBatchV3AndUp(events);
                }
            }
            catch (Exception e) {
                executionException = e;
                break block13;
            }
            finally {
                for (PersistentActorUpdateEvent event : events) {
                    if (event.getEventListener() == null) continue;
                    if (executionException == null) {
                        event.getEventListener().onDone(event.getMessage());
                        continue;
                    }
                    event.getEventListener().onError(event.getMessage(), (Throwable)executionException);
                }
                if (logger.isTraceEnabled()) {
                    long duration = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - startTime);
                    logger.trace("Updating {} Actor state entrie(s) took {} microsecs", (Object)events.size(), (Object)duration);
                }
            }
            for (PersistentActorUpdateEvent event : events) {
                if (event.getEventListener() == null) continue;
                if (executionException == null) {
                    event.getEventListener().onDone(event.getMessage());
                    continue;
                }
                event.getEventListener().onError(event.getMessage(), (Throwable)executionException);
            }
            if (logger.isTraceEnabled()) {
                long duration = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - startTime);
                logger.trace("Updating {} Actor state entrie(s) took {} microsecs", (Object)events.size(), (Object)duration);
            }
        }
    }

    private void executeBatchV3AndUp(List<PersistentActorUpdateEvent> events) {
        BatchStatement batchStatement = BatchStatement.newInstance((BatchType)BatchType.UNLOGGED);
        for (PersistentActorUpdateEvent event : events) {
            if (event.hasPersistentActorBytes()) {
                batchStatement.add((BatchableStatement)this.insertStatement.bind(new Object[]{event.getRowKey()[0], event.getRowKey()[1], event.getPersistentActorId(), event.getPersistentActorBytes()}));
                continue;
            }
            batchStatement.add((BatchableStatement)this.deleteStatement.bind(new Object[]{event.getRowKey()[0], event.getRowKey()[1], event.getPersistentActorId()}));
        }
        ExecutionUtils.executeWithRetry(this.cassandraSession, (Statement)batchStatement, logger);
    }
}

