/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.configuration;

import io.micrometer.core.instrument.MeterRegistry;
import org.elasticsoftware.elasticactors.cassandra.common.serialization.CompressingSerializer;
import org.elasticsoftware.elasticactors.cassandra.common.serialization.DecompressingDeserializer;
import org.elasticsoftware.elasticactors.cassandra4.cluster.CassandraActorSystemEventListenerRepository;
import org.elasticsoftware.elasticactors.cassandra4.cluster.scheduler.CassandraScheduledMessageRepository;
import org.elasticsoftware.elasticactors.cassandra4.health.CassandraHealthCheck;
import org.elasticsoftware.elasticactors.cassandra4.state.CassandraPersistentActorRepository;
import org.elasticsoftware.elasticactors.cassandra4.state.PersistentActorUpdateEventProcessor;
import org.elasticsoftware.elasticactors.cluster.ActorRefFactory;
import org.elasticsoftware.elasticactors.cluster.ActorSystemEventListenerRepository;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystems;
import org.elasticsoftware.elasticactors.cluster.metrics.MicrometerTagCustomizer;
import org.elasticsoftware.elasticactors.cluster.scheduler.ScheduledMessageRepository;
import org.elasticsoftware.elasticactors.configuration.CassandraSessionManager;
import org.elasticsoftware.elasticactors.serialization.Deserializer;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.elasticsoftware.elasticactors.serialization.Serializer;
import org.elasticsoftware.elasticactors.serialization.internal.ActorRefDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.PersistentActorDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.PersistentActorSerializer;
import org.elasticsoftware.elasticactors.serialization.internal.ScheduledMessageDeserializer;
import org.elasticsoftware.elasticactors.state.PersistentActorRepository;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundEventProcessor;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundExecutor;
import org.elasticsoftware.elasticactors.util.concurrent.ThreadBoundExecutorBuilder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;

public class BackplaneConfiguration {
    @Bean(name={"cassandraSessionManager"})
    public CassandraSessionManager createCassandraSessionManager(Environment env) {
        return new CassandraSessionManager(env);
    }

    @Bean(name={"asyncUpdateExecutor"}, destroyMethod="shutdown")
    public ThreadBoundExecutor createAsyncUpdateExecutor(Environment env, CassandraSessionManager cassandraSessionManager, @Nullable @Qualifier(value="elasticActorsMeterRegistry") MeterRegistry meterRegistry, @Nullable @Qualifier(value="elasticActorsMeterTagCustomizer") MicrometerTagCustomizer tagCustomizer) {
        return ThreadBoundExecutorBuilder.buildBlockingQueueThreadBoundExecutor((Environment)env, (ThreadBoundEventProcessor)new PersistentActorUpdateEventProcessor(cassandraSessionManager.getSession()), (String)"asyncUpdateExecutor", (String)"UPDATE-EXECUTOR-WORKER", (MeterRegistry)meterRegistry, (MicrometerTagCustomizer)tagCustomizer);
    }

    @Bean(name={"persistentActorRepository"})
    public PersistentActorRepository getPersistentActorRepository(@Qualifier(value="asyncUpdateExecutor") ThreadBoundExecutor asyncUpdateExecutor, InternalActorSystems cluster, ActorRefFactory actorRefFactory, CassandraSessionManager cassandraSessionManager, Environment env) {
        Integer compressionThreshold = (Integer)env.getProperty("ea.persistentActorRepository.compressionThreshold", Integer.class, (Object)512);
        CompressingSerializer serializer = new CompressingSerializer((Serializer)new PersistentActorSerializer((SerializationFrameworks)cluster), compressionThreshold.intValue());
        DecompressingDeserializer deserializer = new DecompressingDeserializer((Deserializer)new PersistentActorDeserializer(actorRefFactory, cluster));
        return new CassandraPersistentActorRepository(cassandraSessionManager.getSession(), cluster.getClusterName(), asyncUpdateExecutor, (Serializer)serializer, (Deserializer)deserializer);
    }

    @Bean(name={"scheduledMessageRepository"})
    public ScheduledMessageRepository getScheduledMessageRepository(InternalActorSystems cluster, ActorRefFactory actorRefFactory, CassandraSessionManager cassandraSessionManager) {
        return new CassandraScheduledMessageRepository(cluster.getClusterName(), cassandraSessionManager.getSession(), new ScheduledMessageDeserializer(new ActorRefDeserializer(actorRefFactory)));
    }

    @Bean(name={"actorSystemEventListenerRepository"})
    public ActorSystemEventListenerRepository getActorSystemEventListenerRepository(InternalActorSystems cluster, CassandraSessionManager cassandraSessionManager) {
        return new CassandraActorSystemEventListenerRepository(cluster.getClusterName(), cassandraSessionManager.getSession());
    }

    @Bean(name={"cassandraHealthCheck"})
    public CassandraHealthCheck getHealthCheck(CassandraSessionManager cassandraSessionManager) {
        return new CassandraHealthCheck(cassandraSessionManager.getSession());
    }
}

