/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.configuration;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class CassandraSessionManager {
    private final CqlSession cassandraSession;

    public CassandraSessionManager(Environment env) {
        String cassandraHosts = env.getProperty("ea.cassandra.hosts", "localhost:9042");
        String cassandraKeyspaceName = env.getProperty("ea.cassandra.keyspace", "\"ElasticActors\"");
        Integer cassandraPort = (Integer)env.getProperty("ea.cassandra.port", Integer.class, (Object)9042);
        Set hostSet = StringUtils.commaDelimitedListToSet((String)cassandraHosts);
        String[] contactPoints = new String[hostSet.size()];
        int i = 0;
        for (String host2 : hostSet) {
            contactPoints[i] = host2.contains(":") ? host2.substring(0, host2.indexOf(":")) : host2;
            ++i;
        }
        List contactPointAddresses = Arrays.stream(contactPoints).map(host -> new InetSocketAddress((String)host, (int)cassandraPort)).collect(Collectors.toList());
        DriverConfigLoader driverConfigLoader = ((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)DriverConfigLoader.programmaticBuilder().withDuration((DriverOption)DefaultDriverOption.HEARTBEAT_INTERVAL, Duration.ofSeconds(60L))).withString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, ConsistencyLevel.QUORUM.name())).withString((DriverOption)DefaultDriverOption.RETRY_POLICY_CLASS, "DefaultRetryPolicy")).withString((DriverOption)DefaultDriverOption.RECONNECTION_POLICY_CLASS, "ConstantReconnectionPolicy")).withDuration((DriverOption)DefaultDriverOption.RECONNECTION_BASE_DELAY, Duration.ofSeconds(((Integer)env.getProperty("ea.cassandra.retryDownedHostsDelayInSeconds", Integer.class, (Object)1)).intValue()))).withString((DriverOption)DefaultDriverOption.LOAD_BALANCING_POLICY_CLASS, "DcInferringLoadBalancingPolicy")).build();
        this.cassandraSession = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoints(contactPointAddresses)).withConfigLoader(driverConfigLoader)).withKeyspace(cassandraKeyspaceName)).build();
    }

    public CqlSession getSession() {
        return this.cassandraSession;
    }

    @PreDestroy
    public void destroy() {
        this.cassandraSession.close();
    }
}

