/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.kubernetes.cluster;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DaemonThreadFactory
implements ThreadFactory {
    private static final Logger logger = LoggerFactory.getLogger(DaemonThreadFactory.class);
    private final String name;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public DaemonThreadFactory(String name) {
        this(name, logger);
    }

    public DaemonThreadFactory(String name, Logger logger) {
        this(name, (Thread t, Throwable e) -> logger.error("Uncaught exception thrown", e));
    }

    public DaemonThreadFactory(String name, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.name = name;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName(String.format("%s-%d", this.name, this.threadCount.incrementAndGet()));
        t.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        return t;
    }

    public String toString() {
        return this.name;
    }
}

