/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.configuration;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.elasticsoftware.elasticactors.cluster.ClusterService;
import org.elasticsoftware.elasticactors.shoal.cluster.ShoalClusterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

public class ClusteringConfiguration {
    @Autowired
    private Environment env;

    @Bean(name={"clusterService"})
    public ClusterService createClusterService() throws UnknownHostException {
        String nodeId = this.env.getRequiredProperty("ea.node.id");
        InetAddress nodeAddress = InetAddress.getByName(this.env.getRequiredProperty("ea.node.address"));
        int nodePort = (Integer)this.env.getProperty("ea.node.port", Integer.class, (Object)9090);
        String clusterName = this.env.getRequiredProperty("ea.cluster");
        String discoveryNodes = (String)this.env.getProperty("ea.cluster.discovery.nodes", String.class, null);
        return new ShoalClusterService(clusterName, nodeId, nodeAddress, nodePort, discoveryNodes);
    }
}

