/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.shoal.cluster;

import com.sun.enterprise.ee.cms.core.AliveAndReadyView;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.FailureSuspectedActionFactory;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationSignal;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.MessageActionFactory;
import com.sun.enterprise.ee.cms.core.MessageSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.ee.cms.impl.client.FailureNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.FailureSuspectedActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.GroupLeadershipNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinedAndReadyNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.MessageActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.PlannedShutdownActionFactoryImpl;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyConfigConstants;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.elasticsoftware.elasticactors.PhysicalNode;
import org.elasticsoftware.elasticactors.cluster.ClusterEventListener;
import org.elasticsoftware.elasticactors.cluster.ClusterMessageHandler;
import org.elasticsoftware.elasticactors.cluster.ClusterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShoalClusterService
implements ClusterService {
    private static final Logger logger = LoggerFactory.getLogger(ShoalClusterService.class);
    private static final String COMPONENT_NAME = "ElasticActors";
    private final String clusterName;
    private final String nodeId;
    private final InetAddress nodeAddress;
    private final Integer nodePort;
    private final String discoveryNodes;
    private final AtomicBoolean startupLeadershipSignal = new AtomicBoolean(true);
    private final Queue<ClusterEventListener> eventListeners = new ConcurrentLinkedQueue<ClusterEventListener>();
    private GroupManagementService gms;
    private ClusterMessageHandler clusterMessageHandler;

    public ShoalClusterService(String clusterName, String nodeId, InetAddress nodeAddress, Integer nodePort, @Nullable String discoveryNodes) {
        this.clusterName = clusterName;
        this.nodeId = nodeId;
        this.nodeAddress = nodeAddress;
        this.nodePort = nodePort;
        this.discoveryNodes = discoveryNodes;
    }

    @PostConstruct
    public void init() throws GMSException {
        this.gms = this.initializeGMS(this.nodeId, this.clusterName, this.nodeAddress.getHostAddress());
    }

    @PreDestroy
    public void destroy() {
        this.reportPlannedShutdown();
    }

    public void reportReady() throws Exception {
        this.gms.join();
        this.gms.updateMemberDetails(this.nodeId, (Serializable)((Object)"address"), (Serializable)((Object)this.nodeAddress.getHostAddress()));
        this.gms.reportJoinedAndReadyState();
    }

    public void reportPlannedShutdown() {
        this.gms.shutdown(GMSConstants.shutdownType.INSTANCE_SHUTDOWN);
    }

    public void addEventListener(ClusterEventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    public void removeEventListener(ClusterEventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    public void sendMessage(String memberToken, byte[] message) throws Exception {
        this.gms.getGroupHandle().sendMessage(memberToken, COMPONENT_NAME, message);
    }

    public void setClusterMessageHandler(ClusterMessageHandler clusterMessageHandler) {
        this.clusterMessageHandler = clusterMessageHandler;
    }

    private GroupManagementService initializeGMS(String serverName, String groupName, String interfaceName) throws GMSException {
        Properties props = new Properties();
        props.setProperty(ServiceProviderConfigurationKeys.MULTICASTADDRESS.toString(), "229.9.1.1");
        props.setProperty(GrizzlyConfigConstants.BIND_INTERFACE_NAME.toString(), interfaceName);
        props.setProperty(GrizzlyConfigConstants.TCPSTARTPORT.toString(), this.nodePort.toString());
        props.setProperty(GrizzlyConfigConstants.TCPENDPORT.toString(), this.nodePort.toString());
        if (this.discoveryNodes != null) {
            props.setProperty(GrizzlyConfigConstants.DISCOVERY_URI_LIST.toString(), this.discoveryNodes);
        }
        GroupManagementService gms = (GroupManagementService)GMSFactory.startGMSModule((String)serverName, (String)groupName, (GroupManagementService.MemberType)GroupManagementService.MemberType.CORE, (Properties)props);
        CallBack gmsCallback = notification -> {
            logger.info("Got signal [{}] from member [{}]", (Object)notification.getClass().getSimpleName(), (Object)notification.getMemberToken());
            if (notification instanceof JoinedAndReadyNotificationSignal) {
                this.fireTopologyChanged(((JoinedAndReadyNotificationSignal)notification).getCurrentView());
            } else if (notification instanceof PlannedShutdownSignal) {
                this.fireTopologyChanged(((PlannedShutdownSignal)notification).getCurrentView());
            } else if (notification instanceof FailureNotificationSignal) {
                this.fireTopologyChanged(((FailureNotificationSignal)notification).getCurrentView());
            } else if (notification instanceof GroupLeadershipNotificationSignal) {
                this.fireLeadershipChanged((GroupLeadershipNotificationSignal)notification);
            }
        };
        CallBack messagingCallback = notification -> {
            if (notification instanceof MessageSignal && this.clusterMessageHandler != null) {
                MessageSignal messageSignal = (MessageSignal)notification;
                try {
                    this.clusterMessageHandler.handleMessage(messageSignal.getMessage(), messageSignal.getMemberToken());
                }
                catch (Exception e) {
                    logger.error("Exception while handling MessageSignal from member {}, signal bytes (HEX): -", (Object)messageSignal.getMemberToken(), (Object)e);
                }
            }
        };
        gms.addActionFactory((JoinNotificationActionFactory)new JoinNotificationActionFactoryImpl(gmsCallback));
        gms.addActionFactory((JoinedAndReadyNotificationActionFactory)new JoinedAndReadyNotificationActionFactoryImpl(gmsCallback));
        gms.addActionFactory((GroupLeadershipNotificationActionFactory)new GroupLeadershipNotificationActionFactoryImpl(gmsCallback));
        gms.addActionFactory((FailureSuspectedActionFactory)new FailureSuspectedActionFactoryImpl(gmsCallback));
        gms.addActionFactory((FailureNotificationActionFactory)new FailureNotificationActionFactoryImpl(gmsCallback));
        gms.addActionFactory((PlannedShutdownActionFactory)new PlannedShutdownActionFactoryImpl(gmsCallback));
        gms.addActionFactory((MessageActionFactory)new MessageActionFactoryImpl(messagingCallback), COMPONENT_NAME);
        return gms;
    }

    private void fireTopologyChanged(AliveAndReadyView currentView) {
        List coreMembers = this.gms.getGroupHandle().getCurrentCoreMembers();
        logger.info("fireTopologyChanged members in view: {}", (Object)coreMembers);
        for (ClusterEventListener eventListener : this.eventListeners) {
            try {
                eventListener.onTopologyChanged(this.convert(coreMembers));
            }
            catch (Exception e) {
                logger.error("Exception on fireTopologyChanged -> Aborting", (Throwable)e);
            }
        }
    }

    private synchronized void fireLeadershipChanged(GroupLeadershipNotificationSignal signal) {
        block7: {
            block6: {
                if (this.startupLeadershipSignal.compareAndSet(true, false)) break block6;
                logger.info("fireLeadershipChanged member: " + signal.getMemberToken());
                for (ClusterEventListener eventListener : this.eventListeners) {
                    try {
                        eventListener.onMasterElected(this.convert(Collections.singletonList(signal.getMemberToken())).get(0));
                    }
                    catch (Exception e) {
                        logger.error("Exception on fireLeadershipChanged", (Throwable)e);
                    }
                }
                break block7;
            }
            if (signal.getMemberToken().equals(this.nodeId)) break block7;
            this.startupLeadershipSignal.set(true);
            logger.info("fireLeadershipChanged member: " + signal.getMemberToken());
            for (ClusterEventListener eventListener : this.eventListeners) {
                try {
                    eventListener.onMasterElected(this.convert(Collections.singletonList(signal.getMemberToken())).get(0));
                }
                catch (Exception e) {
                    logger.error("Exception on fireLeadershipChanged", (Throwable)e);
                }
            }
        }
    }

    private List<PhysicalNode> convert(List<String> coreMembers) throws IOException {
        LinkedList<PhysicalNode> clusterNodes = new LinkedList<PhysicalNode>();
        for (String member : coreMembers) {
            if (this.nodeId.equals(member)) {
                clusterNodes.add(new PhysicalNode(this.nodeId, this.nodeAddress, true));
                continue;
            }
            InetAddress address = InetAddress.getByName((String)this.gms.getMemberDetails(member).get("address"));
            clusterNodes.add(new PhysicalNode(member, address, false));
        }
        return clusterNodes;
    }
}

