/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.client.spring;

import org.elasticsoftware.elasticactors.MessageDeliveryException;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;
import org.elasticsoftware.elasticactors.messaging.MessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.core.MessageBuilderSupport;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.MessagePropertiesBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbitTemplateMessageQueue
implements MessageQueue {
    private static final Logger logger = LoggerFactory.getLogger(RabbitTemplateMessageQueue.class);
    private final String exchange;
    private final String routingKey;
    private final RabbitTemplate rabbitTemplate;

    public RabbitTemplateMessageQueue(String exchange, String routingKey, RabbitTemplate rabbitTemplate) {
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.rabbitTemplate = rabbitTemplate;
    }

    private MessageProperties createProps(InternalMessage message) {
        MessageBuilderSupport messageBuilderSupport = MessagePropertiesBuilder.newInstance().setContentType("application/octet-stream").setDeliveryMode(message.isDurable() ? MessageDeliveryMode.PERSISTENT : MessageDeliveryMode.NON_PERSISTENT);
        if (message.getTimeout() < 0) {
            return (MessageProperties)messageBuilderSupport.build();
        }
        return (MessageProperties)messageBuilderSupport.setPriority(MessageProperties.DEFAULT_PRIORITY).setExpiration(String.valueOf(message.getTimeout())).build();
    }

    public boolean offer(InternalMessage message) {
        try {
            this.rabbitTemplate.send(this.exchange, this.routingKey, MessageBuilder.withBody((byte[])message.toByteArray()).andProperties(this.createProps(message)).build());
        }
        catch (Exception e) {
            throw new MessageDeliveryException("Unexpected exception while sending message using RabbitTemplate", (Throwable)e, false);
        }
        return true;
    }

    public boolean add(InternalMessage message) {
        return this.offer(message);
    }

    public InternalMessage poll() {
        throw new UnsupportedOperationException("Client message queues cannot poll messages");
    }

    public String getName() {
        return this.routingKey;
    }

    public void initialize() throws Exception {
        logger.info("Starting remote message queue [{}->{}]", (Object)this.exchange, (Object)this.routingKey);
    }

    public void destroy() {
        logger.info("Stopping remote message queue [{}->{}]", (Object)this.exchange, (Object)this.routingKey);
    }
}

