/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.client.spring;

import org.elasticsoftware.elasticactors.client.spring.RabbitTemplateMessageQueue;
import org.elasticsoftware.elasticactors.messaging.MessageHandler;
import org.elasticsoftware.elasticactors.messaging.MessageQueue;
import org.elasticsoftware.elasticactors.messaging.MessageQueueFactory;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbitTemplateMessageQueueFactory
implements MessageQueueFactory {
    private static final String QUEUE_NAME_FORMAT = "%s/%s";
    private static final String EA_EXCHANGE_FORMAT = "ea.%s";
    private final String elasticActorsCluster;
    private final String exchangeName;
    private final AmqpAdmin amqpAdmin;
    private final RabbitTemplate rabbitTemplate;

    public RabbitTemplateMessageQueueFactory(String elasticActorsCluster, AmqpAdmin amqpAdmin, RabbitTemplate rabbitTemplate) {
        this.elasticActorsCluster = elasticActorsCluster;
        this.amqpAdmin = amqpAdmin;
        this.rabbitTemplate = rabbitTemplate;
        this.exchangeName = String.format(EA_EXCHANGE_FORMAT, elasticActorsCluster);
    }

    public MessageQueue create(String name, MessageHandler messageHandler) throws Exception {
        String queueName = String.format(QUEUE_NAME_FORMAT, this.elasticActorsCluster, name);
        this.ensureQueueExists(queueName);
        RabbitTemplateMessageQueue messageQueue = new RabbitTemplateMessageQueue(this.exchangeName, queueName, this.rabbitTemplate);
        messageQueue.initialize();
        return messageQueue;
    }

    private void ensureQueueExists(String queueName) {
        Queue queue = QueueBuilder.durable((String)queueName).build();
        this.amqpAdmin.declareQueue(queue);
        DirectExchange exchange = (DirectExchange)ExchangeBuilder.directExchange((String)this.exchangeName).build();
        this.amqpAdmin.declareBinding(BindingBuilder.bind((Queue)queue).to(exchange).with(queueName));
    }
}

