/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.client.cluster;

import javax.annotation.Nullable;
import org.elasticsoftware.elasticactors.client.cluster.BaseDisconnectedActorRef;

final class DisconnectedRemoteActorNodeRef
extends BaseDisconnectedActorRef {
    private final String nodeId;

    DisconnectedRemoteActorNodeRef(String clusterName, String actorSystemName, String nodeId, @Nullable String actorId) {
        super(actorId, clusterName, DisconnectedRemoteActorNodeRef.generateRefSpec(clusterName, actorSystemName, nodeId, actorId), actorSystemName);
        this.nodeId = nodeId;
    }

    public static String generateRefSpec(String clusterName, String actorSystemName, String nodeId, String actorId) {
        if (actorId != null) {
            return "actor://" + clusterName + "/" + actorSystemName + "/nodes/" + nodeId + "/" + actorId;
        }
        return "actor://" + clusterName + "/" + actorSystemName + "/nodes/" + nodeId;
    }

    public String getActorPath() {
        return this.actorSystemName + "/nodes/" + this.nodeId;
    }

    @Override
    protected String getExceptionMessage() {
        return String.format("Cannot reach Remote Actor Node %s in cluster [%s] using a Remote Actor Reference", this.nodeId, this.clusterName);
    }
}

