/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.client.cluster;

import org.elasticsoftware.elasticactors.client.cluster.BaseDisconnectedActorRef;

final class DisconnectedRemoteActorShardRef
extends BaseDisconnectedActorRef {
    private final int shardId;

    DisconnectedRemoteActorShardRef(String clusterName, String actorSystemName, String actorId, int shardId) {
        super(actorId, clusterName, DisconnectedRemoteActorShardRef.generateRefSpec(clusterName, actorSystemName, shardId, actorId), actorSystemName);
        this.shardId = shardId;
    }

    public static String generateRefSpec(String clusterName, String actorSystemName, int shardId, String actorId) {
        if (actorId != null) {
            return "actor://" + clusterName + "/" + actorSystemName + "/shards/" + shardId + "/" + actorId;
        }
        return "actor://" + clusterName + "/" + actorSystemName + "/shards/" + shardId;
    }

    public String getActorPath() {
        return this.actorSystemName + "/shards/" + this.shardId;
    }

    @Override
    protected String getExceptionMessage() {
        return String.format("Remote Actor Cluster %s is not configured, ensure a correct remote configuration", this.clusterName);
    }
}

