/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.client.cluster;

import org.elasticsoftware.elasticactors.client.cluster.BaseDisconnectedActorRef;

final class DisconnectedServiceActorRef
extends BaseDisconnectedActorRef {
    private final String nodeId;

    DisconnectedServiceActorRef(String clusterName, String actorSystemName, String nodeId, String serviceId) {
        super(serviceId, clusterName, DisconnectedServiceActorRef.generateRefSpec(clusterName, actorSystemName, nodeId, serviceId), actorSystemName);
        this.nodeId = nodeId;
    }

    public static String generateRefSpec(String clusterName, String actorSystemName, String nodeId, String actorId) {
        if (actorId != null) {
            return "actor://" + clusterName + "/" + actorSystemName + "/services/" + nodeId + "/" + actorId;
        }
        return "actor://" + clusterName + "/" + actorSystemName + "/services/" + nodeId;
    }

    public String getActorPath() {
        return this.actorSystemName + "/services/" + this.nodeId;
    }

    @Override
    protected String getExceptionMessage() {
        return String.format("Cannot reach Remote Actor Service %s for node %s in cluster [%s] using a Remote Actor Reference", this.actorId, this.nodeId, this.clusterName);
    }
}

