/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.client.cluster;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.ActorShard;
import org.elasticsoftware.elasticactors.PhysicalNode;
import org.elasticsoftware.elasticactors.RemoteActorSystemConfiguration;
import org.elasticsoftware.elasticactors.ShardKey;
import org.elasticsoftware.elasticactors.client.cluster.RemoteActorShardRef;
import org.elasticsoftware.elasticactors.client.messaging.ActorSystemMessage;
import org.elasticsoftware.elasticactors.client.serialization.ActorSystemMessageSerializer;
import org.elasticsoftware.elasticactors.messaging.DefaultInternalMessage;
import org.elasticsoftware.elasticactors.messaging.Hasher;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;
import org.elasticsoftware.elasticactors.messaging.MessageHandler;
import org.elasticsoftware.elasticactors.messaging.MessageHandlerEventListener;
import org.elasticsoftware.elasticactors.messaging.MessageQueueFactory;
import org.elasticsoftware.elasticactors.messaging.MessageQueueProxy;
import org.elasticsoftware.elasticactors.messaging.MultiMessageQueueProxy;
import org.elasticsoftware.elasticactors.messaging.MultiMessageQueueProxyHasher;
import org.elasticsoftware.elasticactors.messaging.SingleMessageQueueProxy;
import org.elasticsoftware.elasticactors.serialization.Message;
import org.elasticsoftware.elasticactors.serialization.MessageSerializer;
import org.elasticsoftware.elasticactors.serialization.SerializationContext;
import org.elasticsoftware.elasticactors.serialization.SerializationFramework;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;

final class RemoteActorShard
implements ActorShard,
MessageHandler {
    private static final PhysicalNode UNKNOWN_REMOTE_NODE = new PhysicalNode("UNKNOWN", null, false);
    private final ShardKey key;
    private final MessageQueueProxy messageQueueProxy;
    private final SerializationFrameworks serializationFrameworks;
    private final ActorRef myRef;

    RemoteActorShard(RemoteActorSystemConfiguration configuration, ShardKey key, MessageQueueFactory messageQueueFactory, SerializationFrameworks serializationFrameworks) {
        this.key = key;
        this.serializationFrameworks = serializationFrameworks;
        this.myRef = new RemoteActorShardRef(configuration.getClusterName(), this, null);
        this.messageQueueProxy = configuration.getQueuesPerShard() <= 1 ? new SingleMessageQueueProxy(messageQueueFactory, (MessageHandler)this, this.myRef) : new MultiMessageQueueProxy((Hasher)new MultiMessageQueueProxyHasher(Integer.valueOf(configuration.getMultiQueueHashSeed())), messageQueueFactory, (MessageHandler)this, this.myRef, configuration.getQueuesPerShard());
    }

    public ShardKey getKey() {
        return this.key;
    }

    public PhysicalNode getOwningNode() {
        return this.getPhysicalNode();
    }

    public ActorRef getActorRef() {
        return this.myRef;
    }

    public void sendMessage(ActorRef sender, ActorRef receiver, Object message) throws Exception {
        this.sendMessage(sender, (List<? extends ActorRef>)ImmutableList.of((Object)receiver), message);
    }

    public void sendMessage(ActorRef sender, List<? extends ActorRef> receiver, Object message) throws Exception {
        MessageSerializer<?> messageSerializer = this.getSerializer(message.getClass());
        boolean durable = this.isDurable(message);
        int timeout = this.getTimeout(message);
        String payloadClass = this.getPayloadClass(message);
        this.messageQueueProxy.offerInternalMessage((InternalMessage)new DefaultInternalMessage(null, ImmutableList.copyOf(receiver), SerializationContext.serialize(messageSerializer, (Object)message), payloadClass, message, durable, timeout));
    }

    private boolean isDurable(Object message) {
        Message messageAnnotation = message.getClass().getAnnotation(Message.class);
        if (messageAnnotation != null) {
            return messageAnnotation.durable();
        }
        if (message instanceof ActorSystemMessage) {
            return ((ActorSystemMessage)message).isDurable();
        }
        return true;
    }

    private int getTimeout(Object message) {
        Message messageAnnotation = message.getClass().getAnnotation(Message.class);
        if (messageAnnotation != null) {
            return messageAnnotation.timeout();
        }
        if (message instanceof ActorSystemMessage) {
            return ((ActorSystemMessage)message).getTimeout();
        }
        return -1;
    }

    private String getPayloadClass(Object message) {
        Message messageAnnotation = message.getClass().getAnnotation(Message.class);
        if (messageAnnotation == null && message instanceof ActorSystemMessage) {
            return ((ActorSystemMessage)message).getPayloadClass();
        }
        return message.getClass().getName();
    }

    private <T> MessageSerializer<T> getSerializer(Class<T> messageClass) {
        Message messageAnnotation = messageClass.getAnnotation(Message.class);
        if (messageAnnotation != null) {
            SerializationFramework framework = this.serializationFrameworks.getSerializationFramework(messageAnnotation.serializationFramework());
            return framework.getSerializer(messageClass);
        }
        if (ActorSystemMessage.class.isAssignableFrom(messageClass)) {
            return ActorSystemMessageSerializer.get();
        }
        return null;
    }

    public void undeliverableMessage(InternalMessage undeliverableMessage, ActorRef receiverRef) throws Exception {
    }

    public void offerInternalMessage(InternalMessage message) {
        this.messageQueueProxy.offerInternalMessage(message);
    }

    public PhysicalNode getPhysicalNode() {
        return UNKNOWN_REMOTE_NODE;
    }

    public void handleMessage(InternalMessage message, MessageHandlerEventListener mhel) {
        mhel.onError(message, (Throwable)new UnsupportedOperationException("Remote ActorSystem shards can't handle messages"));
    }

    public void init() throws Exception {
        this.messageQueueProxy.init();
    }

    public void destroy() {
        this.messageQueueProxy.destroy();
    }
}

