/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.client.cluster;

import javax.annotation.Nullable;
import org.elasticsoftware.elasticactors.ActorContainer;
import org.elasticsoftware.elasticactors.ActorContainerRef;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.ActorShard;
import org.elasticsoftware.elasticactors.MessageDeliveryException;
import org.elasticsoftware.elasticactors.concurrent.ActorCompletableFuture;
import org.reactivestreams.Publisher;

final class RemoteActorShardRef
implements ActorRef,
ActorContainerRef {
    private final String clusterName;
    private final ActorShard shard;
    private final String actorId;
    private final String refSpec;

    RemoteActorShardRef(String clusterName, ActorShard shard, String actorId) {
        this.clusterName = clusterName;
        this.shard = shard;
        this.actorId = actorId;
        this.refSpec = RemoteActorShardRef.generateRefSpec(clusterName, shard, actorId);
    }

    public static String generateRefSpec(String clusterName, ActorShard shard, @Nullable String actorId) {
        if (actorId != null) {
            return "actor://" + clusterName + "/" + shard.getKey().getActorSystemName() + "/shards/" + shard.getKey().getShardId() + "/" + actorId;
        }
        return "actor://" + clusterName + "/" + shard.getKey().getActorSystemName() + "/shards/" + shard.getKey().getShardId();
    }

    public String getActorCluster() {
        return this.clusterName;
    }

    public String getActorPath() {
        return this.shard.getKey().getActorSystemName() + "/shards/" + this.shard.getKey().getShardId();
    }

    public String getActorId() {
        return this.actorId;
    }

    public void tell(Object message, ActorRef sender) throws MessageDeliveryException {
        if (sender != null) {
            throw new IllegalArgumentException("Can only send anonymous messages (i.e. no sender");
        }
        this.tell(message);
    }

    public void tell(Object message) throws IllegalStateException, MessageDeliveryException {
        try {
            this.shard.sendMessage(null, (ActorRef)this, message);
        }
        catch (MessageDeliveryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageDeliveryException("Unexpected Exception while sending message", (Throwable)e, false);
        }
    }

    public <T> ActorCompletableFuture<T> ask(Object message, Class<T> responseType) {
        ActorCompletableFuture future = new ActorCompletableFuture();
        future.completeExceptionally((Throwable)this.getAskException());
        return future;
    }

    public <T> ActorCompletableFuture<T> ask(Object message, Class<T> responseType, Boolean persistOnResponse) {
        ActorCompletableFuture future = new ActorCompletableFuture();
        future.completeExceptionally((Throwable)this.getAskException());
        return future;
    }

    private UnsupportedOperationException getAskException() {
        return new UnsupportedOperationException("Remote actors references cannot use ask");
    }

    public boolean isLocal() {
        return false;
    }

    public <T> Publisher<T> publisherOf(Class<T> messageClass) {
        return s -> s.onError((Throwable)new UnsupportedOperationException("Remote actor refs can't publish"));
    }

    public boolean equals(Object o) {
        return this == o || o instanceof ActorRef && this.refSpec.equals(o.toString());
    }

    public int hashCode() {
        return this.refSpec.hashCode();
    }

    public String toString() {
        return this.refSpec;
    }

    public ActorContainer getActorContainer() {
        return this.shard;
    }
}

