/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.client.cluster;

import com.google.common.cache.Cache;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.client.cluster.BaseDisconnectedActorRef;
import org.elasticsoftware.elasticactors.client.cluster.DisconnectedRemoteActorNodeRef;
import org.elasticsoftware.elasticactors.client.cluster.DisconnectedRemoteActorShardRef;
import org.elasticsoftware.elasticactors.client.cluster.DisconnectedServiceActorRef;
import org.elasticsoftware.elasticactors.client.cluster.RemoteActorShardRef;
import org.elasticsoftware.elasticactors.client.cluster.RemoteActorSystemInstance;
import org.elasticsoftware.elasticactors.client.cluster.RemoteActorSystems;
import org.elasticsoftware.elasticactors.cluster.ActorRefFactory;
import org.springframework.context.ApplicationContext;

public final class RemoteActorShardRefFactory
implements ActorRefFactory {
    private static final String EXCEPTION_FORMAT = "Invalid ActorRef, required spec: [actor://<cluster>/<actorSystem>/[shards|nodes|services]/<shardId>/<actorId (optional)>, actual spec: [%s]";
    private final ApplicationContext applicationContext;
    private final Cache<String, ActorRef> actorRefCache;
    private RemoteActorSystems actorSystems;

    private RemoteActorSystems getActorSystems() {
        return this.actorSystems != null ? this.actorSystems : (this.actorSystems = (RemoteActorSystems)this.applicationContext.getBean(RemoteActorSystems.class));
    }

    public RemoteActorShardRefFactory(ApplicationContext applicationContext, Cache<String, ActorRef> actorRefCache) {
        this.applicationContext = applicationContext;
        this.actorRefCache = actorRefCache;
    }

    public ActorRef create(String refSpec) {
        ActorRef actorRef = (ActorRef)this.actorRefCache.getIfPresent((Object)refSpec);
        if (actorRef == null && !((actorRef = this.parse(refSpec)) instanceof BaseDisconnectedActorRef)) {
            this.actorRefCache.put((Object)refSpec, (Object)actorRef);
        }
        return actorRef;
    }

    public ActorRef parse(String refSpec) {
        if (refSpec.startsWith("actor://")) {
            int actorSeparatorIndex = 8;
            for (int i = 0; i < 3; ++i) {
                int nextIndex = refSpec.indexOf(47, actorSeparatorIndex + 1);
                if (nextIndex == -1) {
                    throw new IllegalArgumentException(String.format(EXCEPTION_FORMAT, refSpec));
                }
                actorSeparatorIndex = nextIndex;
            }
            int nextIndex = refSpec.indexOf(47, actorSeparatorIndex + 1);
            String actorId = nextIndex == -1 ? null : refSpec.substring(nextIndex + 1);
            actorSeparatorIndex = nextIndex == -1 ? actorSeparatorIndex : nextIndex;
            String[] components = actorId == null ? refSpec.substring(8).split("/") : refSpec.substring(8, actorSeparatorIndex).split("/");
            return this.handleRemoteActorSystemReference(refSpec, components, actorId);
        }
        throw new IllegalArgumentException(String.format(EXCEPTION_FORMAT, refSpec));
    }

    private ActorRef handleRemoteActorSystemReference(String refSpec, String[] components, String actorId) {
        if ("shards".equals(components[2])) {
            return this.handleRemoteShard(components, actorId);
        }
        if ("nodes".equals(components[2])) {
            return this.handleRemoteNode(components, actorId);
        }
        if ("services".equals(components[2])) {
            return this.handleRemoteService(components, actorId);
        }
        throw new IllegalArgumentException(String.format(EXCEPTION_FORMAT, refSpec));
    }

    private ActorRef handleRemoteShard(String[] components, String actorId) {
        String clusterName = components[0];
        String actorSystemName = components[1];
        RemoteActorSystemInstance remoteActorSystem = this.getActorSystems().get(clusterName, actorSystemName);
        int shardId = Integer.parseInt(components[3]);
        if (remoteActorSystem == null) {
            return new DisconnectedRemoteActorShardRef(clusterName, actorSystemName, actorId, shardId);
        }
        return new RemoteActorShardRef(clusterName, remoteActorSystem.getShard(actorSystemName + "/shards/" + shardId), actorId);
    }

    private ActorRef handleRemoteNode(String[] components, String actorId) {
        String clusterName = components[0];
        String actorSystemName = components[1];
        String nodeId = components[3];
        return new DisconnectedRemoteActorNodeRef(clusterName, actorSystemName, nodeId, actorId);
    }

    private ActorRef handleRemoteService(String[] components, String actorId) {
        String clusterName = components[0];
        String actorSystemName = components[1];
        return new DisconnectedServiceActorRef(clusterName, actorSystemName, components[3], actorId);
    }
}

