/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.client.cluster;

import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.elasticsoftware.elasticactors.ActorContainer;
import org.elasticsoftware.elasticactors.ActorContainerRef;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.ActorRefGroup;
import org.elasticsoftware.elasticactors.ActorShard;
import org.elasticsoftware.elasticactors.ActorState;
import org.elasticsoftware.elasticactors.ActorSystem;
import org.elasticsoftware.elasticactors.ActorSystemConfiguration;
import org.elasticsoftware.elasticactors.ActorSystems;
import org.elasticsoftware.elasticactors.RemoteActorSystemConfiguration;
import org.elasticsoftware.elasticactors.ShardKey;
import org.elasticsoftware.elasticactors.client.cluster.ActorSystemDelegateConfiguration;
import org.elasticsoftware.elasticactors.client.cluster.RemoteActorShard;
import org.elasticsoftware.elasticactors.client.cluster.RemoteActorShardRef;
import org.elasticsoftware.elasticactors.client.messaging.ActorSystemMessage;
import org.elasticsoftware.elasticactors.client.serialization.ActorSystemMessageSerializer;
import org.elasticsoftware.elasticactors.cluster.ActorSystemEventListenerRegistry;
import org.elasticsoftware.elasticactors.cluster.ShardAccessor;
import org.elasticsoftware.elasticactors.messaging.ActorShardHasher;
import org.elasticsoftware.elasticactors.messaging.Hasher;
import org.elasticsoftware.elasticactors.messaging.MessageQueueFactory;
import org.elasticsoftware.elasticactors.messaging.internal.CreateActorMessage;
import org.elasticsoftware.elasticactors.messaging.internal.DestroyActorMessage;
import org.elasticsoftware.elasticactors.scheduler.Scheduler;
import org.elasticsoftware.elasticactors.serialization.Message;
import org.elasticsoftware.elasticactors.serialization.MessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.MessageSerializer;
import org.elasticsoftware.elasticactors.serialization.SerializationAccessor;
import org.elasticsoftware.elasticactors.serialization.SerializationFramework;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteActorSystemInstance
implements ActorSystem,
ShardAccessor,
SerializationAccessor {
    private static final Logger logger = LoggerFactory.getLogger(RemoteActorSystemInstance.class);
    private final RemoteActorSystemConfiguration configuration;
    private final ActorShard[] shards;
    private final Hasher hasher;
    private final SerializationFrameworks serializationFrameworks;
    private final MessageQueueFactory messageQueueFactory;

    RemoteActorSystemInstance(RemoteActorSystemConfiguration configuration, SerializationFrameworks serializationFrameworks, MessageQueueFactory messageQueueFactory) {
        this.configuration = configuration;
        this.serializationFrameworks = serializationFrameworks;
        this.messageQueueFactory = messageQueueFactory;
        this.shards = new ActorShard[configuration.getNumberOfShards()];
        this.hasher = new ActorShardHasher(Integer.valueOf(configuration.getShardHashSeed()));
    }

    public String getName() {
        return this.configuration.getName();
    }

    public <T> ActorRef actorOf(String actorId, Class<T> actorClass) throws Exception {
        return this.actorOf(actorId, actorClass.getName(), null);
    }

    public ActorRef actorOf(String actorId, String actorClassName) throws Exception {
        return this.actorOf(actorId, actorClassName, null);
    }

    public <T> ActorRef actorOf(String actorId, Class<T> actorClass, ActorState initialState) throws Exception {
        return this.actorOf(actorId, actorClass.getName(), initialState);
    }

    public ActorRef actorOf(String actorId, String actorClassName, ActorState initialState) throws Exception {
        return this.actorOf(actorId, actorClassName, initialState, null);
    }

    public ActorRef actorOf(String actorId, String actorClassName, ActorState initialState, ActorRef creatorRef) throws Exception {
        ActorShard shard = this.shardFor(actorId);
        CreateActorMessage createActorMessage = new CreateActorMessage(this.getName(), actorClassName, actorId, initialState);
        shard.sendMessage(null, shard.getActorRef(), (Object)createActorMessage);
        return new RemoteActorShardRef(this.configuration.getClusterName(), shard, actorId);
    }

    public <T> ActorRef tempActorOf(Class<T> actorClass, @Nullable ActorState initialState) throws Exception {
        throw new UnsupportedOperationException("Temporary Actors are not supported for Remote ActorSystem instances");
    }

    public ActorRef actorFor(String actorId) {
        ActorShard shard = this.shardFor(actorId);
        return new RemoteActorShardRef(this.configuration.getClusterName(), shard, actorId);
    }

    private ActorShard shardFor(String actorId) {
        return this.shards[Math.abs(this.hasher.hashStringToInt(actorId)) % this.shards.length];
    }

    public ActorRef serviceActorFor(String actorId) {
        throw new UnsupportedOperationException("Service Actors are not supported for Remote ActorSystem instances");
    }

    public ActorRef serviceActorFor(String nodeId, String actorId) {
        throw new UnsupportedOperationException("Service Actors are not supported for Remote ActorSystem instances");
    }

    public Scheduler getScheduler() {
        throw new UnsupportedOperationException("Scheduler is not supported for Remote ActorSystem instances");
    }

    public ActorSystems getParent() {
        throw new UnsupportedOperationException("Parent ActorSystem not available for remote ActorSystem instances");
    }

    public void stop(ActorRef actorRef) throws Exception {
        ActorContainer handlingContainer = ((ActorContainerRef)actorRef).getActorContainer();
        handlingContainer.sendMessage(null, handlingContainer.getActorRef(), (Object)new DestroyActorMessage(actorRef));
    }

    public ActorSystemConfiguration getConfiguration() {
        return new ActorSystemDelegateConfiguration(this.configuration);
    }

    public ActorSystemEventListenerRegistry getEventListenerRegistry() {
        throw new UnsupportedOperationException("Event listener registry is not supported for remote ActorSystem instances");
    }

    public ActorRefGroup groupOf(Collection<ActorRef> members) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Creating Remote ActorRefGroup objects is not supported for Remote ActorSystem instances");
    }

    @PostConstruct
    public void init() throws Exception {
        logger.info("Initializing Remote Actor System [{}/{}]", (Object)this.configuration.getClusterName(), (Object)this.configuration.getName());
        for (int i = 0; i < this.shards.length; ++i) {
            this.shards[i] = new RemoteActorShard(this.configuration, new ShardKey(this.configuration.getName(), i), this.messageQueueFactory, this.serializationFrameworks);
        }
        for (ActorShard shard : this.shards) {
            shard.init();
        }
    }

    @PreDestroy
    public void destroy() {
        logger.info("Destroying Remote Actor System [{}/{}]", (Object)this.configuration.getClusterName(), (Object)this.configuration.getName());
        for (ActorShard shard : this.shards) {
            shard.destroy();
        }
    }

    public ActorShard getShard(String actorPath) {
        String[] pathElements = actorPath.split("/");
        if (pathElements[1].equals("shards")) {
            return this.getShard(Integer.parseInt(pathElements[2]));
        }
        throw new IllegalArgumentException(String.format("No ActorShard found for actorPath [%s]", actorPath));
    }

    public ActorShard getShard(int shardId) {
        return this.shards[shardId];
    }

    public int getNumberOfShards() {
        return this.shards.length;
    }

    public <T> MessageSerializer<T> getSerializer(Class<T> messageClass) {
        MessageSerializer messageSerializer = this.serializationFrameworks.getSystemMessageSerializer(messageClass);
        if (messageSerializer == null) {
            Message messageAnnotation = messageClass.getAnnotation(Message.class);
            if (messageAnnotation != null) {
                SerializationFramework framework = this.serializationFrameworks.getSerializationFramework(messageAnnotation.serializationFramework());
                messageSerializer = framework.getSerializer(messageClass);
            } else if (ActorSystemMessage.class.isAssignableFrom(messageClass)) {
                messageSerializer = ActorSystemMessageSerializer.get();
            }
        }
        return messageSerializer;
    }

    public <T> MessageDeserializer<T> getDeserializer(Class<T> messageClass) {
        Message messageAnnotation;
        MessageDeserializer messageDeserializer = this.serializationFrameworks.getSystemMessageDeserializer(messageClass);
        if (messageDeserializer == null && (messageAnnotation = messageClass.getAnnotation(Message.class)) != null) {
            SerializationFramework framework = this.serializationFrameworks.getSerializationFramework(messageAnnotation.serializationFramework());
            messageDeserializer = framework.getDeserializer(messageClass);
        }
        return messageDeserializer;
    }
}

