/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.client.cluster;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.elasticsoftware.elasticactors.RemoteActorSystemConfiguration;
import org.elasticsoftware.elasticactors.client.cluster.RemoteActorSystemInstance;
import org.elasticsoftware.elasticactors.messaging.MessageQueueFactoryFactory;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteActorSystems {
    private static final Logger logger = LoggerFactory.getLogger(RemoteActorSystems.class);
    private final Map<String, RemoteActorSystemInstance> remoteActorSystems;

    public RemoteActorSystems(List<RemoteActorSystemConfiguration> remoteConfigurations, SerializationFrameworks serializationFrameworks, MessageQueueFactoryFactory messageQueueFactoryFactory) {
        this.remoteActorSystems = remoteConfigurations.stream().collect(Collectors.toMap(RemoteActorSystemConfiguration::getClusterName, remoteConfiguration -> new RemoteActorSystemInstance((RemoteActorSystemConfiguration)remoteConfiguration, serializationFrameworks, messageQueueFactoryFactory.create(remoteConfiguration.getClusterName()))));
    }

    @PostConstruct
    public void init() {
        this.remoteActorSystems.forEach((key, value) -> {
            try {
                value.init();
                logger.info("Added Remote ActorSystem [{}] with {} shards on Cluster [{}]", new Object[]{value.getName(), value.getNumberOfShards(), key});
            }
            catch (Exception e) {
                logger.error("Exception while initializing Remote ActorSystem [{}]", (Object)value.getName(), (Object)e);
            }
        });
    }

    @PreDestroy
    public void destroy() {
        this.remoteActorSystems.forEach((s, remoteActorSystemInstance) -> remoteActorSystemInstance.destroy());
    }

    public RemoteActorSystemInstance get(String clusterName, String actorSystemName) {
        RemoteActorSystemInstance actorSystem = this.remoteActorSystems.get(clusterName);
        if (actorSystem != null && actorSystem.getName().equals(actorSystemName)) {
            return actorSystem;
        }
        return null;
    }

    public RemoteActorSystemInstance get(String actorSystemName) {
        List instances = this.remoteActorSystems.values().stream().filter(actorSystem -> actorSystem.getName().equals(actorSystemName)).collect(Collectors.toList());
        if (!instances.isEmpty()) {
            if (instances.size() > 1) {
                throw new IllegalArgumentException("Found multiple matching Remote ActorSystems, please use ActorSystems.get(clusterName, actorSystemName");
            }
            return (RemoteActorSystemInstance)instances.get(0);
        }
        return null;
    }
}

