/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.client.configuration;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.RemoteActorSystemConfiguration;
import org.elasticsoftware.elasticactors.client.cluster.RemoteActorShardRefFactory;
import org.elasticsoftware.elasticactors.client.cluster.RemoteActorSystems;
import org.elasticsoftware.elasticactors.client.serialization.ClientSerializationFrameworks;
import org.elasticsoftware.elasticactors.client.serialization.SerializedActorStateSerializationFramework;
import org.elasticsoftware.elasticactors.messaging.MessageQueueFactoryFactory;
import org.elasticsoftware.elasticactors.serialization.SerializationFramework;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

public class ClientConfiguration {
    @Bean
    public ClientSerializationFrameworks clientSerializationFrameworks(RemoteActorShardRefFactory actorShardRefFactory, List<SerializationFramework> serializationFrameworks) {
        return new ClientSerializationFrameworks(actorShardRefFactory, serializationFrameworks);
    }

    @Bean
    public RemoteActorShardRefFactory remoteActorShardRefFactory(ApplicationContext applicationContext, @Value(value="${ea.actorRefCache.maximumSize:10240}") Integer maximumSize) {
        Cache actorRefCache = CacheBuilder.newBuilder().maximumSize((long)maximumSize.intValue()).build();
        return new RemoteActorShardRefFactory(applicationContext, (Cache<String, ActorRef>)actorRefCache);
    }

    @Bean
    public RemoteActorSystems remoteActorSystems(List<RemoteActorSystemConfiguration> remoteConfigurations, SerializationFrameworks serializationFrameworks, MessageQueueFactoryFactory remoteActorSystemMessageQueueFactoryFactory) {
        return new RemoteActorSystems(remoteConfigurations, serializationFrameworks, remoteActorSystemMessageQueueFactoryFactory);
    }

    @Bean
    public SerializedActorStateSerializationFramework serializedActorStateSerializationFramework() {
        return new SerializedActorStateSerializationFramework();
    }
}

