/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.client.serialization;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsoftware.elasticactors.client.serialization.ClientSystemDeserializers;
import org.elasticsoftware.elasticactors.client.serialization.ClientSystemSerializers;
import org.elasticsoftware.elasticactors.cluster.ActorRefFactory;
import org.elasticsoftware.elasticactors.serialization.MessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.MessageSerializer;
import org.elasticsoftware.elasticactors.serialization.SerializationFramework;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.elasticsoftware.elasticactors.serialization.SystemDeserializers;
import org.elasticsoftware.elasticactors.serialization.SystemSerializers;

public final class ClientSerializationFrameworks
implements SerializationFrameworks {
    private final SystemSerializers systemSerializers = new ClientSystemSerializers(this);
    private final SystemDeserializers systemDeserializers;
    private final Map<Class<? extends SerializationFramework>, SerializationFramework> serializationFrameworkMap;

    public ClientSerializationFrameworks(ActorRefFactory actorRefFactory, List<SerializationFramework> serializationFrameworks) {
        this.systemDeserializers = new ClientSystemDeserializers(this, actorRefFactory);
        this.serializationFrameworkMap = serializationFrameworks.stream().collect(Collectors.toMap(Object::getClass, Function.identity()));
    }

    public <T> MessageSerializer<T> getSystemMessageSerializer(Class<T> messageClass) {
        return this.systemSerializers.get(messageClass);
    }

    public <T> MessageDeserializer<T> getSystemMessageDeserializer(Class<T> messageClass) {
        return this.systemDeserializers.get(messageClass);
    }

    public SerializationFramework getSerializationFramework(Class<? extends SerializationFramework> frameworkClass) {
        return this.serializationFrameworkMap.get(frameworkClass);
    }
}

