/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.client.serialization;

import com.google.common.collect.ImmutableMap;
import org.elasticsoftware.elasticactors.cluster.ActorRefFactory;
import org.elasticsoftware.elasticactors.messaging.internal.ActivateActorMessage;
import org.elasticsoftware.elasticactors.messaging.internal.CancelScheduledMessageMessage;
import org.elasticsoftware.elasticactors.messaging.internal.CreateActorMessage;
import org.elasticsoftware.elasticactors.messaging.internal.DestroyActorMessage;
import org.elasticsoftware.elasticactors.serialization.MessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.elasticsoftware.elasticactors.serialization.SystemDeserializers;
import org.elasticsoftware.elasticactors.serialization.internal.ActivateActorMessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.ActorRefDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.CancelScheduledMessageMessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.CreateActorMessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.DestroyActorMessageDeserializer;

public final class ClientSystemDeserializers
implements SystemDeserializers {
    private final ImmutableMap<Class, MessageDeserializer> systemDeserializers;

    public ClientSystemDeserializers(SerializationFrameworks serializationFrameworks, ActorRefFactory actorRefFactory) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ActorRefDeserializer actorRefDeserializer = new ActorRefDeserializer(actorRefFactory);
        builder.put(CreateActorMessage.class, (Object)new CreateActorMessageDeserializer(serializationFrameworks));
        builder.put(DestroyActorMessage.class, (Object)new DestroyActorMessageDeserializer(actorRefDeserializer));
        builder.put(ActivateActorMessage.class, (Object)new ActivateActorMessageDeserializer());
        builder.put(CancelScheduledMessageMessage.class, (Object)new CancelScheduledMessageMessageDeserializer());
        this.systemDeserializers = builder.build();
    }

    public <T> MessageDeserializer<T> get(Class<T> messageClass) {
        return (MessageDeserializer)this.systemDeserializers.get(messageClass);
    }
}

