/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.client.serialization;

import com.google.common.collect.ImmutableMap;
import org.elasticsoftware.elasticactors.messaging.internal.ActivateActorMessage;
import org.elasticsoftware.elasticactors.messaging.internal.CancelScheduledMessageMessage;
import org.elasticsoftware.elasticactors.messaging.internal.CreateActorMessage;
import org.elasticsoftware.elasticactors.messaging.internal.DestroyActorMessage;
import org.elasticsoftware.elasticactors.serialization.MessageSerializer;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.elasticsoftware.elasticactors.serialization.SystemSerializers;
import org.elasticsoftware.elasticactors.serialization.internal.ActivateActorMessageSerializer;
import org.elasticsoftware.elasticactors.serialization.internal.CancelScheduleMessageMessageSerializer;
import org.elasticsoftware.elasticactors.serialization.internal.CreateActorMessageSerializer;
import org.elasticsoftware.elasticactors.serialization.internal.DestroyActorMessageSerializer;

public final class ClientSystemSerializers
implements SystemSerializers {
    private final ImmutableMap<Class, MessageSerializer> systemSerializers;

    public ClientSystemSerializers(SerializationFrameworks serializationFrameworks) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(CreateActorMessage.class, (Object)new CreateActorMessageSerializer(serializationFrameworks));
        builder.put(DestroyActorMessage.class, (Object)new DestroyActorMessageSerializer());
        builder.put(ActivateActorMessage.class, (Object)new ActivateActorMessageSerializer());
        builder.put(CancelScheduledMessageMessage.class, (Object)new CancelScheduleMessageMessageSerializer());
        this.systemSerializers = builder.build();
    }

    public <T> MessageSerializer<T> get(Class<T> messageClass) {
        return (MessageSerializer)this.systemSerializers.get(messageClass);
    }
}

