/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.kafka.serialization;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.elasticsoftware.elasticactors.serialization.Deserializer;

public final class DecompressingDeserializer<O>
implements Deserializer<byte[], O> {
    private static final LZ4FastDecompressor lz4Decompressor = LZ4Factory.fastestJavaInstance().fastDecompressor();
    private static final byte[] MAGIC_HEADER = new byte[]{24, 77, 34, 4};
    private final Deserializer<byte[], O> delegate;

    public DecompressingDeserializer(Deserializer<byte[], O> delegate) {
        this.delegate = delegate;
    }

    public O deserialize(byte[] serializedObject) throws IOException {
        if (this.isCompressed(serializedObject)) {
            ByteArrayDataInput dataInput = ByteStreams.newDataInput((byte[])serializedObject);
            dataInput.skipBytes(4);
            int uncompressedLength = dataInput.readInt();
            return (O)this.delegate.deserialize((Object)lz4Decompressor.decompress(serializedObject, 8, uncompressedLength));
        }
        return (O)this.delegate.deserialize((Object)serializedObject);
    }

    private boolean isCompressed(byte[] serializedObject) {
        for (int i = 0; i < MAGIC_HEADER.length; ++i) {
            if (serializedObject[i] == MAGIC_HEADER[i]) continue;
            return false;
        }
        return true;
    }
}

