/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.kafka.state;

import java.io.IOException;
import org.elasticsoftware.elasticactors.ShardKey;
import org.elasticsoftware.elasticactors.kafka.state.ChronicleMapPersistentActorStore;
import org.elasticsoftware.elasticactors.kafka.state.InMemoryPersistentActorStore;
import org.elasticsoftware.elasticactors.kafka.state.PersistentActorStore;
import org.elasticsoftware.elasticactors.kafka.state.PersistentActorStoreFactory;
import org.elasticsoftware.elasticactors.serialization.Deserializer;
import org.elasticsoftware.elasticactors.state.PersistentActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public final class ChronicleMapPersistentActorStoreFactory
implements PersistentActorStoreFactory {
    private static final Logger logger = LoggerFactory.getLogger(ChronicleMapPersistentActorStoreFactory.class);
    private Environment environment;

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public PersistentActorStore create(ShardKey shardKey, Deserializer<byte[], PersistentActor<ShardKey>> deserializer) {
        try {
            String dataDir = (String)this.environment.getProperty("ea.kafka.persistentActorStore.dataDirectory", String.class, (Object)System.getProperty("java.io.tmpdir"));
            Double averageKeySize = (Double)this.environment.getProperty("ea.kafka.persistentActorStore.averageKeySize", Double.class, (Object)45.0);
            Double averageValueSize = (Double)this.environment.getProperty("ea.kafka.persistentActorStore.averageValueSize", Double.class, (Object)512.0);
            Long maxEntries = (Long)this.environment.getProperty("ea.kafka.persistentActorStore.averageValueSize", Long.class, (Object)0x100000L);
            return new ChronicleMapPersistentActorStore(shardKey, deserializer, dataDir, averageKeySize, averageValueSize, maxEntries);
        }
        catch (IOException e) {
            logger.warn("IOException while creating ChronicleMapPersistenActorStore, falling back to InMemoryPersistentActorStore", (Throwable)e);
            return new InMemoryPersistentActorStore(shardKey, deserializer);
        }
    }
}

