/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.kafka.state;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsoftware.elasticactors.ShardKey;
import org.elasticsoftware.elasticactors.kafka.state.PersistentActorStore;
import org.elasticsoftware.elasticactors.serialization.Deserializer;
import org.elasticsoftware.elasticactors.state.PersistentActor;

public final class InMemoryPersistentActorStore
implements PersistentActorStore {
    private final ShardKey shardKey;
    private final Map<String, byte[]> backingMap;
    private final Deserializer<byte[], PersistentActor<ShardKey>> deserializer;

    public InMemoryPersistentActorStore(ShardKey shardKey, Deserializer<byte[], PersistentActor<ShardKey>> deserializer) {
        this.shardKey = shardKey;
        this.deserializer = deserializer;
        this.backingMap = new HashMap<String, byte[]>();
    }

    @Override
    public ShardKey getShardKey() {
        return this.shardKey;
    }

    @Override
    public void put(String actorId, byte[] persistentActorBytes) {
        this.backingMap.put(actorId, persistentActorBytes);
    }

    @Override
    public void put(String actorId, byte[] persistentActorBytes, long offset) {
        this.backingMap.put(actorId, persistentActorBytes);
    }

    @Override
    public void remove(String actorId) {
        this.backingMap.remove(actorId);
    }

    @Override
    public boolean containsKey(String actorId) {
        return this.backingMap.containsKey(actorId);
    }

    @Override
    public PersistentActor<ShardKey> getPersistentActor(String actorId) {
        byte[] persistentActorBytes = this.backingMap.get(actorId);
        try {
            return persistentActorBytes != null ? (PersistentActor)this.deserializer.deserialize((Object)persistentActorBytes) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int count() {
        return this.backingMap.size();
    }
}

