/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.kafka.utils;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystem;
import org.elasticsoftware.elasticactors.kafka.utils.TopicNamesHelper;

public final class TopicHelper {
    private static final Short DEFAULT_REPLICATION_FACTOR = new Short("3");

    private TopicHelper() {
    }

    public static void ensureTopicsExists(String bootstrapServers, String nodeId, int nodePartitions, InternalActorSystem internalActorSystem) throws Exception {
        String actorSystemEventListenersTopicName;
        String scheduledMessagesTopicName;
        String persistentActorsTopicName;
        String nodeMessagesTopicName;
        HashMap<String, String> adminClientConfig = new HashMap<String, String>();
        adminClientConfig.put("bootstrap.servers", bootstrapServers);
        adminClientConfig.put("client.id", nodeId + "-adminClient");
        AdminClient adminClient = AdminClient.create(adminClientConfig);
        ListTopicsResult listTopicsResult = adminClient.listTopics();
        Map availableTopics = (Map)listTopicsResult.namesToListings().get();
        String messagesTopicName = TopicNamesHelper.getMessagesTopic(internalActorSystem);
        if (!availableTopics.containsKey(messagesTopicName)) {
            NewTopic topic = new NewTopic(messagesTopicName, internalActorSystem.getNumberOfShards(), DEFAULT_REPLICATION_FACTOR.shortValue());
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.put("cleanup.policy", "delete");
            configs.put("max.message.bytes", "10485760");
            configs.put("min.insync.replicas", "2");
            configs.put("retention.ms", "604800000");
            configs.put("segment.ms", "604800000");
            topic.configs(configs);
            CreateTopicsResult result = adminClient.createTopics((Collection)Lists.newArrayList((Object[])new NewTopic[]{topic}));
            result.all().get();
        }
        if (!availableTopics.containsKey(nodeMessagesTopicName = TopicNamesHelper.getNodeMessagesTopic(internalActorSystem, nodeId))) {
            NewTopic topic = new NewTopic(nodeMessagesTopicName, nodePartitions, DEFAULT_REPLICATION_FACTOR.shortValue());
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.put("cleanup.policy", "delete");
            configs.put("max.message.bytes", "10485760");
            configs.put("min.insync.replicas", "2");
            configs.put("retention.ms", "604800000");
            configs.put("segment.ms", "604800000");
            topic.configs(configs);
            CreateTopicsResult result = adminClient.createTopics((Collection)Lists.newArrayList((Object[])new NewTopic[]{topic}));
            result.all().get();
        }
        if (!availableTopics.containsKey(persistentActorsTopicName = TopicNamesHelper.getPersistentActorsTopic(internalActorSystem))) {
            NewTopic topic = new NewTopic(persistentActorsTopicName, internalActorSystem.getNumberOfShards(), DEFAULT_REPLICATION_FACTOR.shortValue());
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.put("cleanup.policy", "compact");
            configs.put("delete.retention.ms", "86400000");
            configs.put("max.message.bytes", "20971520");
            configs.put("min.cleanable.dirty.ratio", "0.5");
            configs.put("min.insync.replicas", "2");
            configs.put("retention.ms", "9223372036854775807");
            configs.put("segment.ms", "604800000");
            topic.configs(configs);
            CreateTopicsResult result = adminClient.createTopics((Collection)Lists.newArrayList((Object[])new NewTopic[]{topic}));
            result.all().get();
        }
        if (!availableTopics.containsKey(scheduledMessagesTopicName = TopicNamesHelper.getScheduledMessagesTopic(internalActorSystem))) {
            NewTopic topic = new NewTopic(scheduledMessagesTopicName, internalActorSystem.getNumberOfShards(), DEFAULT_REPLICATION_FACTOR.shortValue());
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.put("cleanup.policy", "compact");
            configs.put("delete.retention.ms", "86400000");
            configs.put("max.message.bytes", "20971520");
            configs.put("min.cleanable.dirty.ratio", "0.5");
            configs.put("min.insync.replicas", "2");
            configs.put("retention.ms", "9223372036854775807");
            configs.put("segment.ms", "604800000");
            topic.configs(configs);
            CreateTopicsResult result = adminClient.createTopics((Collection)Lists.newArrayList((Object[])new NewTopic[]{topic}));
            result.all().get();
        }
        if (!availableTopics.containsKey(actorSystemEventListenersTopicName = TopicNamesHelper.getActorsystemEventListenersTopic(internalActorSystem))) {
            NewTopic topic = new NewTopic(actorSystemEventListenersTopicName, internalActorSystem.getNumberOfShards(), DEFAULT_REPLICATION_FACTOR.shortValue());
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.put("cleanup.policy", "compact");
            configs.put("delete.retention.ms", "86400000");
            configs.put("max.message.bytes", "20971520");
            configs.put("min.cleanable.dirty.ratio", "0.5");
            configs.put("min.insync.replicas", "2");
            configs.put("retention.ms", "9223372036854775807");
            configs.put("segment.ms", "604800000");
            topic.configs(configs);
            CreateTopicsResult result = adminClient.createTopics((Collection)Lists.newArrayList((Object[])new NewTopic[]{topic}));
            result.all().get();
        }
        adminClient.close();
    }
}

