/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.kafka;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.elasticsoftware.elasticactors.ActorNode;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.NodeKey;
import org.elasticsoftware.elasticactors.PhysicalNode;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystem;
import org.elasticsoftware.elasticactors.cluster.LocalClusterActorNodeRef;
import org.elasticsoftware.elasticactors.kafka.KafkaActorThread;
import org.elasticsoftware.elasticactors.messaging.DefaultInternalMessage;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;
import org.elasticsoftware.elasticactors.messaging.InternalMessageFactory;
import org.elasticsoftware.elasticactors.serialization.MessageSerializer;

public final class KafkaActorNode
implements ActorNode {
    private final NodeKey key;
    private final PhysicalNode node;
    private final KafkaActorThread actorThread;
    private final InternalActorSystem actorSystem;
    private final ActorRef myRef;

    public KafkaActorNode(PhysicalNode node, KafkaActorThread actorThread, InternalActorSystem actorSystem) {
        this.key = new NodeKey(actorSystem.getName(), node.getId());
        this.myRef = new LocalClusterActorNodeRef(actorSystem, actorSystem.getParent().getClusterName(), (ActorNode)this);
        this.node = node;
        this.actorThread = actorThread;
        this.actorSystem = actorSystem;
        if (node.isLocal()) {
            actorThread.assign(this, true);
        }
    }

    public NodeKey getKey() {
        return this.key;
    }

    public boolean isLocal() {
        return this.node.isLocal();
    }

    public ActorRef getActorRef() {
        return this.myRef;
    }

    public void sendMessage(ActorRef sender, ActorRef receiver, Object message) throws Exception {
        this.sendMessage(sender, (List<? extends ActorRef>)ImmutableList.of((Object)receiver), message);
    }

    public void sendMessage(ActorRef sender, ActorRef receiver, int partition, Object message) throws Exception {
        this.sendMessage(sender, (List<? extends ActorRef>)ImmutableList.of((Object)receiver), partition, message);
    }

    public void sendMessage(ActorRef sender, List<? extends ActorRef> receivers, Object message) throws Exception {
        this.offerInternalMessage(this.createInternalMessage(sender, receivers, message));
    }

    public void sendMessage(ActorRef sender, List<? extends ActorRef> receivers, int partition, Object message) throws Exception {
        this.offerInternalMessage(partition, this.createInternalMessage(sender, receivers, message));
    }

    public void undeliverableMessage(InternalMessage message, ActorRef receiverRef) throws Exception {
        DefaultInternalMessage undeliverableMessage = InternalMessageFactory.copyForUndeliverableWithSerializedPayload((InternalMessage)message, (ActorRef)receiverRef);
        this.offerInternalMessage((InternalMessage)undeliverableMessage);
    }

    public void offerInternalMessage(InternalMessage internalMessage) {
        this.actorThread.send(this.key, 0, internalMessage);
    }

    public void offerInternalMessage(int partition, InternalMessage internalMessage) {
        this.actorThread.send(this.key, partition, internalMessage);
    }

    public void init() throws Exception {
    }

    public void destroy() {
    }

    KafkaActorThread getActorThread() {
        return this.actorThread;
    }

    CompletableFuture<Void> initializeServiceActors() {
        return this.actorThread.initializeServiceActors();
    }

    private InternalMessage createInternalMessage(ActorRef from, List<? extends ActorRef> to, Object message) throws IOException {
        MessageSerializer messageSerializer = this.actorSystem.getSerializer(message.getClass());
        return InternalMessageFactory.createWithSerializedPayload((ActorRef)from, to, (MessageSerializer)messageSerializer, (Object)message);
    }
}

