/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.kafka.cluster;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.elasticsoftware.elasticactors.ActorLifecycleListener;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.ActorState;
import org.elasticsoftware.elasticactors.ElasticActor;
import org.elasticsoftware.elasticactors.MessageDeliveryException;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystem;
import org.elasticsoftware.elasticactors.cluster.tasks.ActorLifecycleTask;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;
import org.elasticsoftware.elasticactors.messaging.reactivestreams.NextMessage;
import org.elasticsoftware.elasticactors.serialization.SerializationAccessor;
import org.elasticsoftware.elasticactors.serialization.SerializationFramework;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.elasticsoftware.elasticactors.state.ActorLifecycleStep;
import org.elasticsoftware.elasticactors.state.PersistentActor;
import org.elasticsoftware.elasticactors.util.ByteBufferUtils;
import org.elasticsoftware.elasticactors.util.SerializationTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationProtocol {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationProtocol.class);

    private static void executeLifecycleListeners(InternalActorSystem actorSystem, PersistentActor persistentActor, BiConsumer<ActorLifecycleListener, PersistentActor> lifecycleConsumer) {
        List lifecycleListeners = actorSystem.getActorLifecycleListeners(persistentActor.getActorClass());
        if (lifecycleListeners != null) {
            for (ActorLifecycleListener lifecycleListener : lifecycleListeners) {
                try {
                    lifecycleConsumer.accept(lifecycleListener, persistentActor);
                }
                catch (Throwable t) {
                    logger.warn("Exception while executing ActorLifecycleListener", t);
                }
            }
        }
    }

    public static Boolean activateActor(InternalActorSystem actorSystem, PersistentActor persistentActor, ElasticActor receiver, ActorRef receiverRef, InternalMessage internalMessage) {
        boolean overridePersistenceConfig = false;
        if (persistentActor.getSerializedState() != null) {
            SerializationFramework framework = SerializationTools.getSerializationFramework((SerializationFrameworks)actorSystem.getParent(), receiver.getClass());
            try {
                ActorState actorState = receiver.preActivate(persistentActor.getPreviousActorStateVersion(), persistentActor.getCurrentActorStateVersion(), persistentActor.getSerializedState(), framework);
                if (actorState == null) {
                    actorState = SerializationTools.deserializeActorState((SerializationFrameworks)actorSystem.getParent(), receiver.getClass(), (byte[])persistentActor.getSerializedState());
                } else {
                    overridePersistenceConfig = true;
                }
                persistentActor.setState(actorState);
                persistentActor.setSerializedState(null);
            }
            catch (Exception e) {
                logger.error("Exception calling preActivate for actorId [{}]", (Object)receiverRef.getActorId(), (Object)e);
            }
        }
        try {
            receiver.postActivate(persistentActor.getPreviousActorStateVersion());
            ApplicationProtocol.executeLifecycleListeners(actorSystem, persistentActor, (a, p) -> a.postActivate(p.getSelf(), p.getState(), p.getPreviousActorStateVersion()));
        }
        catch (Exception e) {
            logger.error("Exception calling postActivate for actorId [{}]", (Object)receiverRef.getActorId(), (Object)e);
            return false;
        }
        return overridePersistenceConfig || ActorLifecycleTask.shouldUpdateState((ElasticActor)receiver, (ActorLifecycleStep)ActorLifecycleStep.ACTIVATE);
    }

    public static Boolean passivateActor(InternalActorSystem actorSystem, PersistentActor persistentActor, ElasticActor receiver, ActorRef receiverRef, InternalMessage internalMessage) {
        try {
            receiver.prePassivate();
            ApplicationProtocol.executeLifecycleListeners(actorSystem, persistentActor, (a, p) -> a.prePassivate(p.getSelf(), p.getState()));
        }
        catch (Exception e) {
            logger.error("Exception calling prePassivate", (Throwable)e);
        }
        return ActorLifecycleTask.shouldUpdateState((ElasticActor)receiver, (ActorLifecycleStep)ActorLifecycleStep.PASSIVATE);
    }

    public static Boolean createActor(InternalActorSystem actorSystem, PersistentActor persistentActor, ElasticActor receiver, ActorRef receiverRef, @Nullable InternalMessage internalMessage) {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating Actor for ref [{}] of type [{}]", (Object)receiverRef, (Object)receiver.getClass().getName());
        }
        try {
            receiver.postCreate(internalMessage == null ? null : internalMessage.getSender());
            ApplicationProtocol.executeLifecycleListeners(actorSystem, persistentActor, (a, p) -> a.postCreate(p.getSelf(), p.getState()));
            receiver.postActivate(null);
            ApplicationProtocol.executeLifecycleListeners(actorSystem, persistentActor, (a, p) -> a.postActivate(p.getSelf(), p.getState(), null));
        }
        catch (Exception e) {
            logger.error("Exception calling postCreate", (Throwable)e);
        }
        return ActorLifecycleTask.shouldUpdateState((ElasticActor)receiver, (ActorLifecycleStep)ActorLifecycleStep.CREATE);
    }

    public static Boolean destroyActor(InternalActorSystem actorSystem, PersistentActor persistentActor, ElasticActor receiver, ActorRef receiverRef, InternalMessage internalMessage) {
        if (logger.isDebugEnabled()) {
            logger.debug("Destroying Actor for ref [{}] of type [{}]", (Object)receiverRef, (Object)receiver.getClass().getName());
        }
        try {
            receiver.preDestroy(null);
            ApplicationProtocol.notifyPublishers(persistentActor);
            ApplicationProtocol.notifySubscribers(persistentActor, internalMessage, receiverRef, actorSystem);
            ApplicationProtocol.executeLifecycleListeners(actorSystem, persistentActor, (a, p) -> a.preDestroy(p.getSelf(), p.getState()));
        }
        catch (Exception e) {
            logger.error("Exception calling preDestroy", (Throwable)e);
        }
        return false;
    }

    public static Boolean handleUndeliverableMessage(InternalActorSystem actorSystem, PersistentActor persistentActor, ElasticActor receiver, ActorRef receiverRef, InternalMessage internalMessage) {
        try {
            Object message = SerializationTools.deserializeMessage((SerializationAccessor)actorSystem, (InternalMessage)internalMessage);
            try {
                receiver.onUndeliverable(internalMessage.getSender(), message);
                return ActorLifecycleTask.shouldUpdateState((ElasticActor)receiver, (Object)message);
            }
            catch (MessageDeliveryException e) {
                if (!e.isRecoverable()) {
                    logger.error("Unrecoverable MessageDeliveryException while handling message for actor [{}]", (Object)receiverRef, (Object)e);
                }
                return ActorLifecycleTask.shouldUpdateState((ElasticActor)receiver, (Object)message);
            }
            catch (Exception e) {
                logger.error("Exception while handling undeliverable message for actor [{}]", (Object)receiverRef, (Object)e);
                return false;
            }
        }
        catch (Exception e) {
            logger.error("Exception while Deserializing Message class {} in ActorSystem [{}]", new Object[]{internalMessage.getPayloadClass(), actorSystem.getName(), e});
            return false;
        }
    }

    public static Boolean handleMessage(InternalActorSystem actorSystem, PersistentActor persistentActor, ElasticActor receiver, ActorRef receiverRef, InternalMessage internalMessage) {
        try {
            Object message = SerializationTools.deserializeMessage((SerializationAccessor)actorSystem, (InternalMessage)internalMessage);
            try {
                receiver.onReceive(internalMessage.getSender(), message);
                ApplicationProtocol.notifySubscribers(persistentActor, internalMessage, receiverRef, actorSystem);
                return ActorLifecycleTask.shouldUpdateState((ElasticActor)receiver, (Object)message);
            }
            catch (MessageDeliveryException e) {
                if (!e.isRecoverable()) {
                    logger.error("Unrecoverable MessageDeliveryException while handling message for actor [{}]", (Object)receiverRef, (Object)e);
                }
                return ActorLifecycleTask.shouldUpdateState((ElasticActor)receiver, (Object)message);
            }
            catch (Exception e) {
                logger.error("Exception while handling message for actor [{}]", (Object)receiverRef, (Object)e);
                return false;
            }
        }
        catch (Exception e) {
            logger.error("Exception while Deserializing Message class {} in ActorSystem [{}]", new Object[]{internalMessage.getPayloadClass(), actorSystem.getName(), e});
            return false;
        }
    }

    private static void notifySubscribers(PersistentActor persistentActor, InternalMessage internalMessage, ActorRef receiverRef, InternalActorSystem actorSystem) {
        if (persistentActor.getMessageSubscribers() != null) {
            try {
                if (persistentActor.getMessageSubscribers().containsKey((Object)internalMessage.getPayloadClass())) {
                    NextMessage nextMessage = new NextMessage(internalMessage.getPayloadClass(), ApplicationProtocol.getMessageBytes(internalMessage, actorSystem));
                    persistentActor.getMessageSubscribers().get((Object)internalMessage.getPayloadClass()).stream().filter(messageSubscriber -> messageSubscriber.getAndDecrement() > 0L).forEach(messageSubscriber -> messageSubscriber.getSubscriberRef().tell((Object)nextMessage, receiverRef));
                }
            }
            catch (Exception e) {
                logger.error("Unexpected exception while forwarding message to Subscribers", (Throwable)e);
            }
        }
    }

    private static void notifyPublishers(PersistentActor persistentActor) {
        try {
            persistentActor.cancelAllSubscriptions();
        }
        catch (Exception e) {
            logger.error("Unexpected Exception while cancelling subscriptions", (Throwable)e);
        }
    }

    private static byte[] getMessageBytes(InternalMessage internalMessage, InternalActorSystem actorSystem) throws IOException {
        if (internalMessage.hasSerializedPayload()) {
            ByteBuffer messagePayload = internalMessage.getPayload();
            return ByteBufferUtils.toByteArrayAndReset((ByteBuffer)messagePayload);
        }
        Object message = internalMessage.getPayload(null);
        ByteBuffer messageBytes = actorSystem.getSerializer(message.getClass()).serialize(message);
        return ByteBufferUtils.toByteArray((ByteBuffer)messageBytes);
    }
}

