/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.kafka.cluster;

import javax.annotation.Nullable;
import org.elasticsoftware.elasticactors.cluster.BaseDisconnectedActorRef;

public final class DisconnectedPartitionedActorNodeRef
extends BaseDisconnectedActorRef {
    private final String nodeId;
    private final int partition;

    DisconnectedPartitionedActorNodeRef(String clusterName, String actorSystemName, String nodeId, int partition, @Nullable String actorId) {
        super(actorId, clusterName, DisconnectedPartitionedActorNodeRef.generateRefSpec(clusterName, actorSystemName, nodeId, partition, actorId), actorSystemName);
        this.nodeId = nodeId;
        this.partition = partition;
    }

    public static String generateRefSpec(String clusterName, String actorSystemName, String nodeId, int partition, String actorId) {
        if (actorId != null) {
            return "actor://" + clusterName + "/" + actorSystemName + "/nodes/" + nodeId + "/" + partition + "/" + actorId;
        }
        return "actor://" + clusterName + "/" + actorSystemName + "/nodes/" + nodeId + "/" + partition;
    }

    public String getActorPath() {
        return this.actorSystemName + "/nodes/" + this.nodeId + "/" + this.partition;
    }

    protected String getExceptionMessage() {
        return String.format("Actor Node %s is not active, referenced actorId cannot be reached and probably doesn't exist anymore. It is a Bad Idea to serialize Temp Actor Refs", this.nodeId);
    }
}

