/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.kafka.cluster;

import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.cluster.ActorRefTools;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystem;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystems;
import org.elasticsoftware.elasticactors.kafka.KafkaActorNode;
import org.elasticsoftware.elasticactors.kafka.cluster.DisconnectedPartitionedActorNodeRef;
import org.elasticsoftware.elasticactors.kafka.cluster.KafkaInternalActorSystems;

public final class KafkaActorRefTools
extends ActorRefTools {
    private final KafkaInternalActorSystems actorSystems;

    public KafkaActorRefTools(KafkaInternalActorSystems actorSystems) {
        super((InternalActorSystems)actorSystems);
        this.actorSystems = actorSystems;
    }

    protected ActorRef handleNode(String[] components, String partitionAndActorId) {
        String clusterName = components[0];
        String actorSystemName = components[1];
        int actorSeparator = partitionAndActorId.indexOf(47);
        int partition = actorSeparator != -1 ? Integer.parseInt(partitionAndActorId.substring(0, actorSeparator)) : Integer.parseInt(partitionAndActorId);
        String actorId = actorSeparator != -1 ? partitionAndActorId.substring(actorSeparator + 1) : null;
        InternalActorSystem actorSystem = this.actorSystems.get(actorSystemName);
        KafkaActorNode node = (KafkaActorNode)actorSystem.getNode(components[3]);
        if (node != null) {
            return this.actorSystems.createTempActorRef(node, partition, actorId);
        }
        return new DisconnectedPartitionedActorNodeRef(clusterName, actorSystemName, components[3], partition, actorId);
    }
}

