/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.kafka.cluster;

import com.google.common.cache.Cache;
import javax.annotation.Nullable;
import org.elasticsoftware.elasticactors.ActorNode;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.ActorShard;
import org.elasticsoftware.elasticactors.ActorSystem;
import org.elasticsoftware.elasticactors.ElasticActor;
import org.elasticsoftware.elasticactors.cluster.ActorRefFactory;
import org.elasticsoftware.elasticactors.cluster.ActorShardRef;
import org.elasticsoftware.elasticactors.cluster.BaseDisconnectedActorRef;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystem;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystems;
import org.elasticsoftware.elasticactors.cluster.RebalancingEventListener;
import org.elasticsoftware.elasticactors.cluster.ServiceActorRef;
import org.elasticsoftware.elasticactors.kafka.KafkaActorNode;
import org.elasticsoftware.elasticactors.kafka.cluster.KafkaActorRefTools;
import org.elasticsoftware.elasticactors.kafka.cluster.LocalClusterPartitionedActorNodeRef;
import org.elasticsoftware.elasticactors.serialization.MessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.MessageSerializer;
import org.elasticsoftware.elasticactors.serialization.MessagingSystemDeserializers;
import org.elasticsoftware.elasticactors.serialization.MessagingSystemSerializers;
import org.elasticsoftware.elasticactors.serialization.SerializationFramework;
import org.elasticsoftware.elasticactors.serialization.SystemDeserializers;
import org.elasticsoftware.elasticactors.serialization.SystemSerializers;

public final class KafkaInternalActorSystems
implements InternalActorSystems,
ActorRefFactory {
    private final InternalActorSystems delegate;
    private final Cache<String, ActorRef> actorRefCache;
    private final KafkaActorRefTools actorRefTools;
    private final SystemSerializers systemSerializers = new MessagingSystemSerializers((InternalActorSystems)this);
    private final SystemDeserializers systemDeserializers = new MessagingSystemDeserializers((InternalActorSystems)this, (ActorRefFactory)this);

    public KafkaInternalActorSystems(InternalActorSystems delegate, Cache<String, ActorRef> actorRefCache) {
        this.delegate = delegate;
        this.actorRefCache = actorRefCache;
        this.actorRefTools = new KafkaActorRefTools(this);
    }

    public String getClusterName() {
        return this.delegate.getClusterName();
    }

    public InternalActorSystem get(String name) {
        return this.delegate.get(name);
    }

    public ActorSystem getRemote(String clusterName, @Nullable String actorSystemName) {
        throw new UnsupportedOperationException("Remote ActorSystems are currently not supported for Kafka based implementation");
    }

    public ActorSystem getRemote(String actorSystemName) {
        throw new UnsupportedOperationException("Remote ActorSystems are currently not supported for Kafka based implementation");
    }

    public void registerRebalancingEventListener(RebalancingEventListener eventListener) {
        this.delegate.registerRebalancingEventListener(eventListener);
    }

    public <T> MessageSerializer<T> getSystemMessageSerializer(Class<T> messageClass) {
        return this.systemSerializers.get(messageClass);
    }

    public <T> MessageDeserializer<T> getSystemMessageDeserializer(Class<T> messageClass) {
        return this.systemDeserializers.get(messageClass);
    }

    public SerializationFramework getSerializationFramework(Class<? extends SerializationFramework> frameworkClass) {
        return this.delegate.getSerializationFramework(frameworkClass);
    }

    public String getActorStateVersion(Class<? extends ElasticActor> actorClass) {
        return this.delegate.getActorStateVersion(actorClass);
    }

    public ActorRef createPersistentActorRef(ActorShard shard, String actorId) {
        String refSpec = ActorShardRef.generateRefSpec((String)this.delegate.getClusterName(), (ActorShard)shard, (String)actorId);
        ActorRef ref = (ActorRef)this.actorRefCache.getIfPresent((Object)refSpec);
        if (ref == null) {
            ref = new ActorShardRef(this.delegate.getClusterName(), shard, actorId, this.get(null));
            this.actorRefCache.put((Object)refSpec, (Object)ref);
        }
        return ref;
    }

    public ActorRef createTempActorRef(ActorNode node, String actorId) {
        throw new UnsupportedOperationException("Not supported in the KafkaActorSystem implementation as the node partition cannot be determined");
    }

    public ActorRef createTempActorRef(KafkaActorNode node, int partition, String actorId) {
        String refSpec = LocalClusterPartitionedActorNodeRef.generateRefSpec(this.delegate.getClusterName(), node, partition, actorId);
        Object ref = (ActorRef)this.actorRefCache.getIfPresent((Object)refSpec);
        if (ref == null) {
            ref = new LocalClusterPartitionedActorNodeRef(this.get(null), this.delegate.getClusterName(), node, partition, actorId);
            this.actorRefCache.put((Object)refSpec, ref);
        }
        return ref;
    }

    public ActorRef createServiceActorRef(ActorNode node, String actorId) {
        String refSpec = ServiceActorRef.generateRefSpec((String)this.delegate.getClusterName(), (ActorNode)node, (String)actorId);
        ActorRef ref = (ActorRef)this.actorRefCache.getIfPresent((Object)refSpec);
        if (ref == null) {
            ref = new ServiceActorRef(this.get(null), this.delegate.getClusterName(), node, actorId);
            this.actorRefCache.put((Object)refSpec, (Object)ref);
        }
        return ref;
    }

    public ActorRef create(String refSpec) {
        ActorRef actorRef = (ActorRef)this.actorRefCache.getIfPresent((Object)refSpec);
        if (actorRef == null && !((actorRef = this.actorRefTools.parse(refSpec)) instanceof BaseDisconnectedActorRef)) {
            this.actorRefCache.put((Object)refSpec, (Object)actorRef);
        }
        return actorRef;
    }
}

