/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.kafka.cluster;

import java.util.List;
import org.elasticsoftware.elasticactors.ActorContainer;
import org.elasticsoftware.elasticactors.ActorContainerRef;
import org.elasticsoftware.elasticactors.ActorContextHolder;
import org.elasticsoftware.elasticactors.ActorNode;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.MessageDeliveryException;
import org.elasticsoftware.elasticactors.cluster.BaseActorRef;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystem;
import org.elasticsoftware.elasticactors.kafka.KafkaActorNode;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;

public final class LocalClusterPartitionedActorNodeRef
extends BaseActorRef
implements ActorContainerRef {
    private final KafkaActorNode node;
    private final int partition;
    private final ActorContainerWrapper actorContainer;

    public LocalClusterPartitionedActorNodeRef(InternalActorSystem actorSystem, String clusterName, KafkaActorNode node, int partition) {
        this(actorSystem, clusterName, node, partition, null);
    }

    public LocalClusterPartitionedActorNodeRef(InternalActorSystem actorSystem, String clusterName, KafkaActorNode node, int partition, String actorId) {
        super(actorSystem, clusterName, actorId, LocalClusterPartitionedActorNodeRef.generateRefSpec(clusterName, node, partition, actorId));
        this.node = node;
        this.partition = partition;
        this.actorContainer = new ActorContainerWrapper();
    }

    public static String generateRefSpec(String clusterName, ActorNode node, int partition, String actorId) {
        if (actorId != null) {
            return "actor://" + clusterName + "/" + node.getKey().getActorSystemName() + "/nodes/" + node.getKey().getNodeId() + "/" + partition + "/" + actorId;
        }
        return "actor://" + clusterName + "/" + node.getKey().getActorSystemName() + "/nodes/" + node.getKey().getNodeId() + "/" + partition;
    }

    public String getActorPath() {
        return this.node.getKey().getActorSystemName() + "/nodes/" + this.node.getKey().getNodeId() + "/" + this.partition;
    }

    public void tell(Object message, ActorRef sender) {
        try {
            this.node.sendMessage(sender, (ActorRef)this, this.partition, message);
        }
        catch (MessageDeliveryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageDeliveryException("Unexpected Exception while sending message", (Throwable)e, false);
        }
    }

    public void tell(Object message) {
        ActorRef self = ActorContextHolder.getSelf();
        if (self == null) {
            throw new IllegalStateException("Cannot determine ActorRef(self). Only use this method while inside an ElasticActor Lifecycle or on(Message) method!");
        }
        this.tell(message, self);
    }

    public boolean isLocal() {
        return this.node.isLocal();
    }

    public ActorContainer getActorContainer() {
        return this.actorContainer;
    }

    private final class ActorContainerWrapper
    implements ActorContainer {
        private ActorContainerWrapper() {
        }

        public ActorRef getActorRef() {
            return new LocalClusterPartitionedActorNodeRef(LocalClusterPartitionedActorNodeRef.this.actorSystem, LocalClusterPartitionedActorNodeRef.this.clusterName, LocalClusterPartitionedActorNodeRef.this.node, LocalClusterPartitionedActorNodeRef.this.partition);
        }

        public void sendMessage(ActorRef sender, ActorRef receiver, Object message) throws Exception {
            LocalClusterPartitionedActorNodeRef.this.node.sendMessage(sender, receiver, LocalClusterPartitionedActorNodeRef.this.partition, message);
        }

        public void sendMessage(ActorRef sender, List<? extends ActorRef> receiver, Object message) throws Exception {
            LocalClusterPartitionedActorNodeRef.this.node.sendMessage(sender, receiver, LocalClusterPartitionedActorNodeRef.this.partition, message);
        }

        public void undeliverableMessage(InternalMessage undeliverableMessage, ActorRef receiverRef) throws Exception {
            LocalClusterPartitionedActorNodeRef.this.node.undeliverableMessage(undeliverableMessage, receiverRef);
        }

        public void offerInternalMessage(InternalMessage message) {
            LocalClusterPartitionedActorNodeRef.this.node.offerInternalMessage(LocalClusterPartitionedActorNodeRef.this.partition, message);
        }

        public void init() throws Exception {
        }

        public void destroy() {
        }
    }
}

