/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.kafka.configuration;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.cache.GuavaCacheMetrics;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.elasticsoftware.elasticactors.ActorLifecycleListenerRegistry;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.InternalActorSystemConfiguration;
import org.elasticsoftware.elasticactors.ManagedActorsRegistry;
import org.elasticsoftware.elasticactors.ShardKey;
import org.elasticsoftware.elasticactors.base.serialization.ObjectMapperBuilder;
import org.elasticsoftware.elasticactors.cache.NodeActorCacheManager;
import org.elasticsoftware.elasticactors.cache.ShardActorCacheManager;
import org.elasticsoftware.elasticactors.cluster.ActorRefFactory;
import org.elasticsoftware.elasticactors.cluster.HashingNodeSelectorFactory;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystem;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystems;
import org.elasticsoftware.elasticactors.cluster.NodeSelectorFactory;
import org.elasticsoftware.elasticactors.cluster.metrics.MicrometerConfiguration;
import org.elasticsoftware.elasticactors.cluster.metrics.MicrometerTagCustomizer;
import org.elasticsoftware.elasticactors.cluster.scheduler.ScheduledMessageRefFactory;
import org.elasticsoftware.elasticactors.cluster.scheduler.ScheduledMessageRefTools;
import org.elasticsoftware.elasticactors.health.InternalActorSystemHealthCheck;
import org.elasticsoftware.elasticactors.kafka.KafkaActorSystemInstance;
import org.elasticsoftware.elasticactors.kafka.serialization.CompressingSerializer;
import org.elasticsoftware.elasticactors.kafka.serialization.DecompressingDeserializer;
import org.elasticsoftware.elasticactors.kafka.state.PersistentActorStoreFactory;
import org.elasticsoftware.elasticactors.runtime.DefaultConfiguration;
import org.elasticsoftware.elasticactors.runtime.ElasticActorsNode;
import org.elasticsoftware.elasticactors.runtime.ManagedActorsScanner;
import org.elasticsoftware.elasticactors.runtime.MessagesScanner;
import org.elasticsoftware.elasticactors.runtime.PluggableMessageHandlersScanner;
import org.elasticsoftware.elasticactors.serialization.Deserializer;
import org.elasticsoftware.elasticactors.serialization.SerializationFrameworks;
import org.elasticsoftware.elasticactors.serialization.Serializer;
import org.elasticsoftware.elasticactors.serialization.SystemSerializationFramework;
import org.elasticsoftware.elasticactors.serialization.internal.PersistentActorDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.PersistentActorSerializer;
import org.elasticsoftware.elasticactors.state.PersistentActor;
import org.elasticsoftware.elasticactors.util.ClassLoadingHelper;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScans;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.Nullable;

@ComponentScans(value={@ComponentScan(value={"org.elasticsoftware.elasticactors.tracing.spring"})})
public class NodeConfiguration {
    @Bean(name={"elasticActorsNode", "actorSystems", "actorRefFactory", "serializationFrameworks"})
    @DependsOn(value={"messageHandlersRegistry", "managedActorsRegistry", "actorLifecycleListenerRegistry"})
    public ElasticActorsNode createElasticActorsNode(Environment env, @Qualifier(value="actorRefCache") Cache<String, ActorRef> actorRefCache) throws UnknownHostException {
        String nodeId = env.getRequiredProperty("ea.node.id");
        InetAddress nodeAddress = InetAddress.getByName(env.getRequiredProperty("ea.node.address"));
        String clusterName = env.getRequiredProperty("ea.cluster");
        return new ElasticActorsNode(clusterName, nodeId, nodeAddress, actorRefCache);
    }

    @Bean(name={"actorRefCache"})
    public Cache<String, ActorRef> createActorRefCache(Environment env, @Nullable @Qualifier(value="elasticActorsMeterRegistry") MeterRegistry meterRegistry, @Nullable @Qualifier(value="elasticActorsMeterTagCustomizer") MicrometerTagCustomizer tagCustomizer) {
        int maximumSize = (Integer)env.getProperty("ea.actorRefCache.maximumSize", Integer.class, (Object)10240);
        MicrometerConfiguration configuration = MicrometerConfiguration.build((Environment)env, (MeterRegistry)meterRegistry, (String)"actorRefCache", (MicrometerTagCustomizer)tagCustomizer);
        CacheBuilder builder = CacheBuilder.newBuilder().maximumSize((long)maximumSize);
        if (configuration != null) {
            builder.recordStats();
            return GuavaCacheMetrics.monitor((MeterRegistry)configuration.getRegistry(), (Cache)builder.build(), (String)configuration.getComponentName(), (Iterable)configuration.getTags());
        }
        return builder.build();
    }

    @Bean(name={"actorSystemConfiguration"})
    public InternalActorSystemConfiguration createConfiguration(ResourceLoader resourceLoader, Environment env) throws IOException {
        Resource configResource = resourceLoader.getResource(env.getProperty("ea.node.config.location", "classpath:ea-default.yaml"));
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (InternalActorSystemConfiguration)objectMapper.readValue(configResource.getInputStream(), DefaultConfiguration.class);
    }

    @Bean(name={"objectMapperBuilder"})
    public ObjectMapperBuilder createObjectMapperBuilder(Environment env, ElasticActorsNode node) {
        String basePackages = (String)env.getProperty("ea.scan.packages", String.class, (Object)"");
        Boolean useAfterburner = (Boolean)env.getProperty("ea.base.useAfterburner", Boolean.class, (Object)Boolean.FALSE);
        ScheduledMessageRefFactory scheduledMessageRefFactory = refSpec -> ScheduledMessageRefTools.parse((String)refSpec, (InternalActorSystems)node);
        ObjectMapperBuilder builder = new ObjectMapperBuilder((ActorRefFactory)node, scheduledMessageRefFactory, basePackages, "1.0.0");
        builder.setUseAfterBurner(useAfterburner.booleanValue());
        return builder;
    }

    @Bean(name={"systemSerializationFramework"})
    public SystemSerializationFramework createSystemSerializationFramework(SerializationFrameworks serializationFrameworks) {
        return new SystemSerializationFramework(serializationFrameworks);
    }

    @Bean(name={"managedActorsRegistry"})
    public ManagedActorsScanner createManagedActorsScanner(ApplicationContext applicationContext) {
        return new ManagedActorsScanner(applicationContext);
    }

    @Bean(name={"messagesScanner"})
    public MessagesScanner createMessageScanner(ApplicationContext applicationContext) {
        return new MessagesScanner(applicationContext);
    }

    @Bean(name={"messageHandlersRegistry"})
    public PluggableMessageHandlersScanner createPluggableMessagesHandlersScanner(ApplicationContext applicationContext) {
        return new PluggableMessageHandlersScanner(applicationContext);
    }

    @Bean(name={"nodeSelectorFactory"})
    public NodeSelectorFactory getNodeSelectorFactory() {
        return new HashingNodeSelectorFactory();
    }

    @Bean(name={"nodeActorCacheManager"})
    public NodeActorCacheManager createNodeActorCacheManager(Environment env, @Nullable @Qualifier(value="elasticActorsMeterRegistry") MeterRegistry meterRegistry, @Nullable @Qualifier(value="elasticActorsMeterTagCustomizer") MicrometerTagCustomizer tagCustomizer) {
        int maximumSize = (Integer)env.getProperty("ea.nodeCache.maximumSize", Integer.class, (Object)10240);
        long expirationCheckPeriod = (Long)env.getProperty("ea.nodeCache.expirationCheckPeriod", Long.class, (Object)30000L);
        return new NodeActorCacheManager(maximumSize, expirationCheckPeriod, MicrometerConfiguration.build((Environment)env, (MeterRegistry)meterRegistry, (String)"nodeActorCache", (MicrometerTagCustomizer)tagCustomizer));
    }

    @Bean(name={"shardActorCacheManager"})
    public ShardActorCacheManager createShardActorCacheManager(Environment env, @Nullable @Qualifier(value="elasticActorsMeterRegistry") MeterRegistry meterRegistry, @Nullable @Qualifier(value="elasticActorsMeterTagCustomizer") MicrometerTagCustomizer tagCustomizer) {
        int maximumSize = (Integer)env.getProperty("ea.shardCache.maximumSize", Integer.class, (Object)10240);
        return new ShardActorCacheManager(maximumSize, MicrometerConfiguration.build((Environment)env, (MeterRegistry)meterRegistry, (String)"shardActorCache", (MicrometerTagCustomizer)tagCustomizer));
    }

    @Bean(name={"internalActorSystem"})
    public InternalActorSystem createLocalActorSystemInstance(ElasticActorsNode node, Environment env, ShardActorCacheManager shardActorCacheManager, NodeActorCacheManager nodeActorCacheManager, ActorLifecycleListenerRegistry actorLifecycleListenerRegistry, PersistentActorStoreFactory persistentActorStoreFactory, ManagedActorsRegistry managedActorsRegistry, @Qualifier(value="actorSystemConfiguration") InternalActorSystemConfiguration configuration, NodeSelectorFactory nodeSelectorFactory, @Qualifier(value="actorRefCache") Cache<String, ActorRef> actorRefCache) {
        int workers = (Integer)env.getProperty("ea.shardThreads.workerCount", Integer.class, (Object)Runtime.getRuntime().availableProcessors());
        String bootstrapServers = env.getRequiredProperty("ea.kafka.bootstrapServers");
        Integer compressionThreshold = (Integer)env.getProperty("ea.persistentActorRepository.compressionThreshold", Integer.class, (Object)512);
        CompressingSerializer<PersistentActor<ShardKey>> serializer = new CompressingSerializer<PersistentActor<ShardKey>>((Serializer<PersistentActor<ShardKey>, byte[]>)new PersistentActorSerializer((SerializationFrameworks)node), compressionThreshold);
        DecompressingDeserializer<PersistentActor<ShardKey>> deserializer = new DecompressingDeserializer<PersistentActor<ShardKey>>((Deserializer<ByteBuffer, PersistentActor<ShardKey>>)new PersistentActorDeserializer((ActorRefFactory)node, (InternalActorSystems)node));
        return new KafkaActorSystemInstance(node, configuration, nodeSelectorFactory, workers, bootstrapServers, actorRefCache, shardActorCacheManager, nodeActorCacheManager, serializer, deserializer, actorLifecycleListenerRegistry, persistentActorStoreFactory, managedActorsRegistry);
    }

    @Bean(name={"internalActorSystemHealthCheck"})
    public InternalActorSystemHealthCheck createHealthCheck(InternalActorSystem internalActorSystem) {
        return new InternalActorSystemHealthCheck(internalActorSystem);
    }

    @Bean(name={"persistentActorStoreFactory"})
    public PersistentActorStoreFactory createPersistentActorStoreFactory(Environment env) throws Exception {
        String className = (String)env.getProperty("ea.kafka.persistentActorStore.factoryClass", String.class, (Object)"InMemoryPeristentActorStoreFactory");
        if (!className.contains(".")) {
            return (PersistentActorStoreFactory)ClassLoadingHelper.getClassHelper().forName("org.elasticsoftware.elasticactors.kafka.state." + className).newInstance();
        }
        return (PersistentActorStoreFactory)ClassLoadingHelper.getClassHelper().forName(className).newInstance();
    }
}

