/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.kafka.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.elasticsoftware.elasticactors.serialization.Deserializer;

public final class DecompressingDeserializer<O>
implements Deserializer<byte[], O> {
    private static final LZ4FastDecompressor lz4Decompressor = LZ4Factory.fastestJavaInstance().fastDecompressor();
    private static final byte[] MAGIC_HEADER = new byte[]{24, 77, 34, 4};
    private final Deserializer<ByteBuffer, O> delegate;

    public DecompressingDeserializer(Deserializer<ByteBuffer, O> delegate) {
        this.delegate = delegate;
    }

    public O deserialize(byte[] serializedBuffer) throws IOException {
        if (this.isCompressed(serializedBuffer)) {
            ByteBuffer buffer = ByteBuffer.wrap(serializedBuffer);
            buffer.position(MAGIC_HEADER.length);
            int uncompressedLength = buffer.getInt();
            buffer.rewind();
            ByteBuffer destination = ByteBuffer.allocate(uncompressedLength);
            lz4Decompressor.decompress(buffer, MAGIC_HEADER.length + 4, destination, 0, uncompressedLength);
            return (O)this.delegate.deserialize((Object)destination);
        }
        return (O)this.delegate.deserialize((Object)ByteBuffer.wrap(serializedBuffer));
    }

    public boolean isSafe() {
        return this.delegate.isSafe();
    }

    private boolean isCompressed(byte[] bytes) {
        if (bytes.length < MAGIC_HEADER.length) {
            return false;
        }
        for (int i = 0; i < MAGIC_HEADER.length; ++i) {
            if (bytes[i] == MAGIC_HEADER[i]) continue;
            return false;
        }
        return true;
    }
}

