/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.kafka.serialization;

import java.util.Map;
import java.util.UUID;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.elasticsoftware.elasticactors.ShardKey;
import org.elasticsoftware.elasticactors.cluster.ActorSystemEventListener;
import org.elasticsoftware.elasticactors.cluster.scheduler.ScheduledMessage;
import org.elasticsoftware.elasticactors.kafka.serialization.KafkaInternalMessageSerializer;
import org.elasticsoftware.elasticactors.kafka.serialization.KafkaPersistentActorSerializer;
import org.elasticsoftware.elasticactors.kafka.serialization.UUIDSerializer;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;
import org.elasticsoftware.elasticactors.serialization.internal.ActorSystemEventListenerSerializer;
import org.elasticsoftware.elasticactors.serialization.internal.ScheduledMessageSerializer;
import org.elasticsoftware.elasticactors.state.PersistentActor;

public final class KafkaProducerSerializer
implements Serializer<Object> {
    private final UUIDSerializer uuidSerializer = new UUIDSerializer();
    private final StringSerializer stringSerializer = new StringSerializer();
    private final KafkaInternalMessageSerializer internalMessageSerializer;
    private final KafkaPersistentActorSerializer persistentActorSerializer;

    public KafkaProducerSerializer(KafkaInternalMessageSerializer internalMessageSerializer, KafkaPersistentActorSerializer persistentActorSerializer) {
        this.internalMessageSerializer = internalMessageSerializer;
        this.persistentActorSerializer = persistentActorSerializer;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] serialize(String topic, Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof UUID) {
            return this.uuidSerializer.serialize(topic, (UUID)data);
        }
        if (data instanceof String) {
            return this.stringSerializer.serialize(topic, (String)data);
        }
        if (data instanceof InternalMessage) {
            return this.internalMessageSerializer.serialize(topic, (InternalMessage)data);
        }
        if (data instanceof byte[]) {
            return (byte[])data;
        }
        if (data instanceof ScheduledMessage) {
            return ScheduledMessageSerializer.get().serialize((ScheduledMessage)data);
        }
        if (data instanceof ActorSystemEventListener) {
            return ActorSystemEventListenerSerializer.get().serialize((ActorSystemEventListener)data);
        }
        if (data instanceof PersistentActor) {
            return this.persistentActorSerializer.serialize(topic, (PersistentActor<ShardKey>)((PersistentActor)data));
        }
        throw new IllegalArgumentException(String.format("Keys nor Values of type %s are supported by this Serializer", data.getClass().getName()));
    }

    public void close() {
    }
}

