/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.kafka.state;

import com.google.common.primitives.Longs;
import java.io.File;
import java.io.IOException;
import net.openhft.chronicle.map.ChronicleMap;
import org.elasticsoftware.elasticactors.ShardKey;
import org.elasticsoftware.elasticactors.kafka.state.PersistentActorStore;
import org.elasticsoftware.elasticactors.serialization.Deserializer;
import org.elasticsoftware.elasticactors.state.PersistentActor;

public final class ChronicleMapPersistentActorStore
implements PersistentActorStore {
    private final ShardKey shardKey;
    private final Deserializer<byte[], PersistentActor<ShardKey>> deserializer;
    private final ChronicleMap<String, byte[]> backingMap;
    private static final String OFFSET_KEY = "____OFFSET___";
    private long offset = -1L;

    ChronicleMapPersistentActorStore(ShardKey shardKey, Deserializer<byte[], PersistentActor<ShardKey>> deserializer) throws IOException {
        this(shardKey, deserializer, System.getProperty("java.io.tmpdir"), 42.0, 512.0, 0x100000L);
    }

    ChronicleMapPersistentActorStore(ShardKey shardKey, Deserializer<byte[], PersistentActor<ShardKey>> deserializer, String dataDirectory, double averageKeySize, double averageValueSize, long maxEntries) throws IOException {
        this.shardKey = shardKey;
        this.deserializer = deserializer;
        File backingFile = new File(dataDirectory + "/" + shardKey.getActorSystemName() + "-" + shardKey.getShardId() + ".cmp");
        this.backingMap = ChronicleMap.of(String.class, byte[].class).averageKeySize(averageKeySize).averageValueSize(averageValueSize).entries(maxEntries).createOrRecoverPersistedTo(backingFile, false);
        byte[] offsetBytes = (byte[])this.backingMap.get((Object)OFFSET_KEY);
        if (offsetBytes != null) {
            this.offset = Longs.fromByteArray((byte[])offsetBytes);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public ShardKey getShardKey() {
        return this.shardKey;
    }

    @Override
    public void put(String actorId, byte[] persistentActorBytes) {
        this.backingMap.put((Object)actorId, (Object)persistentActorBytes);
    }

    @Override
    public void put(String actorId, byte[] persistentActorBytes, long offset) {
        this.backingMap.put((Object)actorId, (Object)persistentActorBytes);
        this.backingMap.put((Object)OFFSET_KEY, (Object)Longs.toByteArray((long)offset));
    }

    @Override
    public boolean containsKey(String actorId) {
        return this.backingMap.containsKey((Object)actorId);
    }

    @Override
    public PersistentActor<ShardKey> getPersistentActor(String actorId) {
        byte[] persistentActorBytes = (byte[])this.backingMap.get((Object)actorId);
        try {
            return persistentActorBytes != null ? (PersistentActor)this.deserializer.deserialize((Object)persistentActorBytes) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove(String actorId) {
        this.backingMap.remove((Object)actorId);
    }

    @Override
    public int count() {
        return Math.max(0, this.backingMap.size() - 1);
    }

    @Override
    public void destroy() {
        this.backingMap.close();
    }

    @Override
    public boolean isConcurrent() {
        return true;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }
}

