/*
 *   Copyright 2013 - 2019 The Original Authors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */

package org.elasticsoftware.elasticactors.serialization.internal;

import com.google.protobuf.ByteString;
import org.elasticsoftware.elasticactors.messaging.internal.PersistActorMessage;
import org.elasticsoftware.elasticactors.serialization.MessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.protobuf.Messaging;

import java.io.IOException;
import java.nio.ByteBuffer;

/**
 * @author Joost van de Wijgerd
 */
public final class PersistActorMessageDeserializer implements MessageDeserializer<PersistActorMessage> {
    private final ActorRefDeserializer actorRefDeserializer;

    public PersistActorMessageDeserializer(ActorRefDeserializer actorRefDeserializer) {
        this.actorRefDeserializer = actorRefDeserializer;
    }

    @Override
    public PersistActorMessage deserialize(ByteBuffer serializedObject) throws IOException {
        Messaging.PersistActorMessage protobufMessage = Messaging.PersistActorMessage.parseFrom(ByteString.copyFrom(serializedObject));
        return new PersistActorMessage(actorRefDeserializer.deserialize(protobufMessage.getActorRef()));
    }

    @Override
    public Class<PersistActorMessage> getMessageClass() {
        return PersistActorMessage.class;
    }
}
