/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.messaging;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import org.elasticsoftware.elasticactors.messaging.Hasher;

public final class ActorShardHasher
implements Hasher {
    private final HashFunction hashFunction;

    public ActorShardHasher() {
        this(0);
    }

    public ActorShardHasher(Integer seed) {
        this.hashFunction = seed == null || seed == 0 ? Hashing.murmur3_32() : Hashing.murmur3_32((int)seed);
    }

    public int hashStringToInt(String value) {
        return this.hashFunction.hashString((CharSequence)value, StandardCharsets.UTF_8).asInt();
    }

    public long hashStringToLong(String value) {
        return this.hashFunction.hashString((CharSequence)value, StandardCharsets.UTF_8).asLong();
    }
}

