/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.messaging;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.messaging.AbstractTracedMessage;
import org.elasticsoftware.elasticactors.messaging.Hasher;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;
import org.elasticsoftware.elasticactors.messaging.Splittable;
import org.elasticsoftware.elasticactors.messaging.SplittableUtils;
import org.elasticsoftware.elasticactors.messaging.UUIDTools;
import org.elasticsoftware.elasticactors.messaging.internal.InternalHashKeyUtils;
import org.elasticsoftware.elasticactors.serialization.MessageDeserializer;
import org.elasticsoftware.elasticactors.serialization.internal.InternalMessageSerializer;
import org.elasticsoftware.elasticactors.tracing.CreationContext;
import org.elasticsoftware.elasticactors.tracing.TraceContext;

public final class ImmutableInternalMessage
extends AbstractTracedMessage
implements InternalMessage,
Serializable,
Splittable<String, InternalMessage> {
    private final ActorRef sender;
    private final ImmutableList<ActorRef> receivers;
    private final UUID id;
    private final ByteBuffer payload;
    private final Object payloadObject;
    private final String messageQueueAffinityKey;
    private final boolean durable;
    private final boolean undeliverable;
    private final int timeout;
    private transient byte[] serializedForm;

    public ImmutableInternalMessage(UUID id, ActorRef sender, ImmutableList<ActorRef> receivers, ByteBuffer payload, Object payloadObject, boolean durable, boolean undeliverable, int timeout, TraceContext traceContext, CreationContext creationContext) {
        super(traceContext, creationContext);
        this.sender = sender;
        this.receivers = receivers;
        this.id = id;
        this.payload = payload;
        this.payloadObject = payloadObject;
        this.messageQueueAffinityKey = InternalHashKeyUtils.getMessageQueueAffinityKey(payloadObject);
        this.durable = durable;
        this.undeliverable = undeliverable;
        this.timeout = timeout;
    }

    @Nullable
    public ActorRef getSender() {
        return this.sender;
    }

    public String getTypeAsString() {
        return this.payloadObject.getClass().getName();
    }

    @Nullable
    public Class<?> getType() {
        return this.payloadObject.getClass();
    }

    public ImmutableList<ActorRef> getReceivers() {
        return this.receivers;
    }

    public UUID getId() {
        return this.id;
    }

    public ByteBuffer getPayload() {
        return this.payload != null ? this.payload.asReadOnlyBuffer() : null;
    }

    public <T> T getPayload(MessageDeserializer<T> deserializer) {
        return (T)this.payloadObject;
    }

    public String getPayloadClass() {
        return this.payloadObject.getClass().getName();
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean isUndeliverable() {
        return this.undeliverable;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean hasSerializedPayload() {
        return this.payload != null;
    }

    public boolean hasPayloadObject() {
        return this.payloadObject != null;
    }

    @Nullable
    public String getMessageQueueAffinityKey() {
        if (this.messageQueueAffinityKey != null) {
            return this.messageQueueAffinityKey;
        }
        return this.receivers.size() == 1 ? ((ActorRef)this.receivers.get(0)).getActorId() : null;
    }

    public byte[] toByteArray() {
        if (this.serializedForm == null) {
            this.serializedForm = InternalMessageSerializer.get().serialize(this);
        }
        return this.serializedForm;
    }

    public InternalMessage copyOf() {
        return this;
    }

    @Override
    public ImmutableMap<Integer, InternalMessage> splitInBuckets(Hasher hasher, int buckets) {
        return this.receivers.size() <= 1 ? ImmutableMap.of((Object)SplittableUtils.calculateBucketForEmptyOrSingleActor(this.receivers, hasher, buckets), (Object)this) : SplittableUtils.groupByBucket(this.receivers, hasher, buckets, this::copyForReceivers);
    }

    private InternalMessage copyForReceivers(List<ActorRef> receivers) {
        return new ImmutableInternalMessage(UUIDTools.createTimeBasedUUID(), this.sender, (ImmutableList<ActorRef>)ImmutableList.copyOf(receivers), this.payload, this.payloadObject, this.durable, this.undeliverable, this.timeout, this.getTraceContext(), this.getCreationContext());
    }
}

