/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.messaging;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.cluster.InternalActorSystem;
import org.elasticsoftware.elasticactors.messaging.DefaultInternalMessage;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;
import org.elasticsoftware.elasticactors.messaging.TransientInternalMessage;
import org.elasticsoftware.elasticactors.serialization.Message;
import org.elasticsoftware.elasticactors.serialization.MessageSerializer;
import org.elasticsoftware.elasticactors.serialization.SerializationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InternalMessageFactory {
    private static final Logger logger = LoggerFactory.getLogger(InternalMessageFactory.class);

    private InternalMessageFactory() {
    }

    public static InternalMessage create(@Nullable ActorRef from, List<? extends ActorRef> to, InternalActorSystem actorSystem, Object message) throws IOException {
        int timeout;
        Message messageAnnotation = message.getClass().getAnnotation(Message.class);
        boolean durable = messageAnnotation != null && messageAnnotation.durable();
        boolean immutable = messageAnnotation != null && messageAnnotation.immutable();
        int n = timeout = messageAnnotation != null ? messageAnnotation.timeout() : -1;
        if (durable || !immutable) {
            return InternalMessageFactory.createDefaultInternalMessage(from, to, actorSystem, message, durable, timeout);
        }
        return InternalMessageFactory.createTransientInternalMessage(from, to, message);
    }

    public static InternalMessage createWithSerializedPayload(@Nullable ActorRef from, List<? extends ActorRef> to, InternalActorSystem actorSystem, Object message) throws IOException {
        Message messageAnnotation = message.getClass().getAnnotation(Message.class);
        boolean durable = messageAnnotation != null && messageAnnotation.durable();
        int timeout = messageAnnotation != null ? messageAnnotation.timeout() : -1;
        return InternalMessageFactory.createDefaultInternalMessage(from, to, actorSystem, message, durable, timeout);
    }

    public static InternalMessage createWithSerializedPayload(@Nullable ActorRef from, List<? extends ActorRef> to, MessageSerializer messageSerializer, Object message) throws IOException {
        Message messageAnnotation = message.getClass().getAnnotation(Message.class);
        boolean durable = messageAnnotation != null && messageAnnotation.durable();
        int timeout = messageAnnotation != null ? messageAnnotation.timeout() : -1;
        return InternalMessageFactory.createDefaultInternalMessage(from, to, messageSerializer, message, durable, timeout);
    }

    public static InternalMessage copyForUndeliverable(InternalMessage message, ActorRef receiverRef) throws IOException {
        if (message instanceof TransientInternalMessage) {
            return new TransientInternalMessage(receiverRef, message.getSender(), message.getPayload(null), true);
        }
        return InternalMessageFactory.copyForUndeliverableWithSerializedPayload(message, receiverRef);
    }

    public static DefaultInternalMessage copyForUndeliverableWithSerializedPayload(InternalMessage message, ActorRef receiverRef) {
        return new DefaultInternalMessage(receiverRef, message.getSender(), message.getPayload(), message.getPayloadClass(), message.isDurable(), true, message.getTimeout());
    }

    private static DefaultInternalMessage createDefaultInternalMessage(ActorRef from, List<? extends ActorRef> to, InternalActorSystem actorSystem, Object message, boolean durable, int timeout) throws IOException {
        MessageSerializer messageSerializer = actorSystem.getSerializer(message.getClass());
        return InternalMessageFactory.createDefaultInternalMessage(from, to, messageSerializer, message, durable, timeout);
    }

    private static DefaultInternalMessage createDefaultInternalMessage(ActorRef from, List<? extends ActorRef> to, MessageSerializer messageSerializer, Object message, boolean durable, int timeout) throws IOException {
        if (messageSerializer == null) {
            logger.error("No message serializer found for class: {}. NOT sending message", (Object)message.getClass().getName());
            return null;
        }
        return new DefaultInternalMessage(from, (ImmutableList<ActorRef>)ImmutableList.copyOf(to), SerializationContext.serialize(messageSerializer, message), message.getClass().getName(), message, durable, timeout);
    }

    private static TransientInternalMessage createTransientInternalMessage(ActorRef from, List<? extends ActorRef> to, Object message) {
        return new TransientInternalMessage(from, (ImmutableList<ActorRef>)ImmutableList.copyOf(to), message);
    }
}

