/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.messaging;

import java.util.UUID;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.cluster.scheduler.ScheduledMessage;
import org.elasticsoftware.elasticactors.cluster.scheduler.ScheduledMessageKey;
import org.elasticsoftware.elasticactors.messaging.AbstractTracedMessage;
import org.elasticsoftware.elasticactors.messaging.UUIDTools;
import org.elasticsoftware.elasticactors.messaging.internal.InternalHashKeyUtils;
import org.elasticsoftware.elasticactors.tracing.CreationContext;
import org.elasticsoftware.elasticactors.tracing.TraceContext;

public final class ScheduledMessageImpl
extends AbstractTracedMessage
implements ScheduledMessage {
    private final UUID id;
    private final long fireTime;
    private final ActorRef sender;
    private final ActorRef receiver;
    private final Class messageClass;
    private final byte[] messageBytes;
    private final ScheduledMessageKey key;
    private final String messageQueueAffinityKey;

    public ScheduledMessageImpl(long fireTime, ActorRef sender, ActorRef receiver, Class messageClass, byte[] messageBytes, Object message) {
        this(UUIDTools.createTimeBasedUUID(), fireTime, sender, receiver, messageClass, messageBytes, InternalHashKeyUtils.getMessageQueueAffinityKey(message));
    }

    private ScheduledMessageImpl(UUID id, long fireTime, ActorRef sender, ActorRef receiver, Class messageClass, byte[] messageBytes, String messageQueueAffinityKey) {
        this.id = id;
        this.fireTime = fireTime;
        this.sender = sender;
        this.receiver = receiver;
        this.messageClass = messageClass;
        this.messageBytes = messageBytes;
        this.key = new ScheduledMessageKey(id, fireTime);
        this.messageQueueAffinityKey = messageQueueAffinityKey;
    }

    public ScheduledMessageImpl(UUID id, long fireTime, ActorRef sender, ActorRef receiver, Class messageClass, byte[] messageBytes, String messageQueueAffinityKey, TraceContext traceContext, CreationContext creationContext) {
        super(traceContext, creationContext);
        this.id = id;
        this.fireTime = fireTime;
        this.sender = sender;
        this.receiver = receiver;
        this.messageClass = messageClass;
        this.messageBytes = messageBytes;
        this.key = new ScheduledMessageKey(id, fireTime);
        this.messageQueueAffinityKey = messageQueueAffinityKey;
    }

    public ScheduledMessageKey getKey() {
        return this.key;
    }

    public UUID getId() {
        return this.id;
    }

    public ActorRef getReceiver() {
        return this.receiver;
    }

    public Class getMessageClass() {
        return this.messageClass;
    }

    @Nullable
    public String getMessageQueueAffinityKey() {
        if (this.messageQueueAffinityKey != null) {
            return this.messageQueueAffinityKey;
        }
        return this.receiver != null ? this.receiver.getActorId() : null;
    }

    public ScheduledMessage copyForRescheduling(long newFireTime) {
        return new ScheduledMessageImpl(newFireTime, this.sender, this.receiver, this.messageClass, this.messageBytes, this.messageQueueAffinityKey);
    }

    public byte[] getMessageBytes() {
        return this.messageBytes;
    }

    @Nullable
    public ActorRef getSender() {
        return this.sender;
    }

    public String getTypeAsString() {
        return this.messageClass.getName();
    }

    @Nullable
    public Class<?> getType() {
        return this.messageClass;
    }

    public long getFireTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.fireTime, TimeUnit.MILLISECONDS);
    }

    private long now() {
        return System.currentTimeMillis();
    }

    public long getDelay(TimeUnit unit) {
        return unit.convert(this.fireTime - this.now(), TimeUnit.MILLISECONDS);
    }

    public int compareTo(Delayed other) {
        if (other == this) {
            return 0;
        }
        long d = this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS);
        if (d != 0L) {
            return d < 0L ? -1 : 1;
        }
        if (other instanceof ScheduledMessage) {
            return this.getId().compareTo(((ScheduledMessage)other).getId());
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledMessage)) {
            return false;
        }
        ScheduledMessage that = (ScheduledMessage)o;
        return this.key.equals((Object)that.getKey());
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

