/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.messaging;

import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;
import org.elasticsoftware.elasticactors.messaging.MessageHandler;
import org.elasticsoftware.elasticactors.messaging.MessageQueue;
import org.elasticsoftware.elasticactors.messaging.MessageQueueFactory;
import org.elasticsoftware.elasticactors.messaging.MessageQueueProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingleMessageQueueProxy
implements MessageQueueProxy {
    private static final Logger logger = LoggerFactory.getLogger(SingleMessageQueueProxy.class);
    private final MessageQueueFactory messageQueueFactory;
    private final MessageHandler messageHandler;
    private final ActorRef actorRef;
    private MessageQueue messageQueue;

    public SingleMessageQueueProxy(MessageQueueFactory messageQueueFactory, MessageHandler messageHandler, ActorRef actorRef) {
        this.messageQueueFactory = messageQueueFactory;
        this.messageHandler = messageHandler;
        this.actorRef = actorRef;
    }

    @Override
    public synchronized void init() throws Exception {
        logger.info("Initializing queue proxy for [{}/{}] in in Single-Queue mode", (Object)this.actorRef.getActorCluster(), (Object)this.actorRef.getActorPath());
        this.messageQueue = this.messageQueueFactory.create(this.actorRef.getActorPath(), this.messageHandler);
    }

    @Override
    public void destroy() {
        logger.info("Destroying queue proxy for [{}/{}]", (Object)this.actorRef.getActorCluster(), (Object)this.actorRef.getActorPath());
        this.messageQueue.destroy();
    }

    @Override
    public void offerInternalMessage(InternalMessage message) {
        this.messageQueue.add(message);
    }
}

