/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.messaging;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.messaging.Hasher;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;

public final class SplittableUtils {
    private SplittableUtils() {
    }

    public static ImmutableMap<Integer, InternalMessage> groupByBucket(List<ActorRef> receivers, Hasher hasher, int buckets, Function<List<ActorRef>, InternalMessage> messageCopyBuilder) {
        if (buckets <= 16) {
            List<ActorRef>[] grouped = SplittableUtils.groupByBucketAsArray(receivers, hasher, buckets);
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)Math.min(receivers.size(), buckets));
            for (int i = 0; i < grouped.length; ++i) {
                List<ActorRef> refs2 = grouped[i];
                if (refs2 == null) continue;
                builder.put((Object)i, (Object)messageCopyBuilder.apply(refs2));
            }
            return builder.build();
        }
        Map<Integer, List<ActorRef>> grouped = SplittableUtils.groupByBucket(receivers, hasher, buckets);
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)grouped.size());
        grouped.forEach((key, refs) -> builder.put(key, messageCopyBuilder.apply((List<ActorRef>)refs)));
        return builder.build();
    }

    public static List<ActorRef>[] groupByBucketAsArray(List<ActorRef> actorRefs, Hasher hasher, int buckets) {
        List[] refs = new List[buckets];
        for (ActorRef ref : actorRefs) {
            int bucket = SplittableUtils.calculateBucket(ref, hasher, buckets);
            ArrayList<ActorRef> refList = refs[bucket];
            if (refList == null) {
                refs[bucket] = refList = new ArrayList<ActorRef>();
            }
            refList.add(ref);
        }
        return refs;
    }

    public static Map<Integer, List<ActorRef>> groupByBucket(List<ActorRef> actorRefs, Hasher hasher, int buckets) {
        HashMap<Integer, List<ActorRef>> map = new HashMap<Integer, List<ActorRef>>();
        for (ActorRef ref : actorRefs) {
            map.computeIfAbsent(SplittableUtils.bucketForHash(SplittableUtils.calculateHash(ref, hasher), buckets), k -> new ArrayList()).add(ref);
        }
        return map;
    }

    private static int bucketForHash(int hash, int buckets) {
        return Math.abs(hash) % buckets;
    }

    public static int calculateBucketForEmptyOrSingleActor(List<ActorRef> actorRefs, Hasher hasher, int buckets) {
        return SplittableUtils.bucketForHash(SplittableUtils.calculateHashForEmptyOrSingleActor(actorRefs, hasher), buckets);
    }

    public static int calculateBucket(ActorRef actorRef, Hasher hasher, int buckets) {
        return SplittableUtils.bucketForHash(SplittableUtils.calculateHash(actorRef, hasher), buckets);
    }

    public static int calculateHashForEmptyOrSingleActor(List<ActorRef> actorRefs, Hasher hasher) {
        return actorRefs.isEmpty() ? 0 : SplittableUtils.calculateHash(actorRefs.get(0), hasher);
    }

    public static int calculateHash(ActorRef actorRef, Hasher hasher) {
        String actorId = actorRef.getActorId();
        return actorId == null ? 0 : hasher.hashStringToInt(actorId);
    }
}

