/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsoftware.elasticactors.messaging;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.elasticsoftware.elasticactors.ActorRef;
import org.elasticsoftware.elasticactors.messaging.AbstractTracedMessage;
import org.elasticsoftware.elasticactors.messaging.DefaultInternalMessage;
import org.elasticsoftware.elasticactors.messaging.Hasher;
import org.elasticsoftware.elasticactors.messaging.InternalMessage;
import org.elasticsoftware.elasticactors.messaging.Splittable;
import org.elasticsoftware.elasticactors.messaging.SplittableUtils;
import org.elasticsoftware.elasticactors.messaging.UUIDTools;
import org.elasticsoftware.elasticactors.messaging.internal.InternalHashKeyUtils;
import org.elasticsoftware.elasticactors.serialization.MessageDeserializer;
import org.elasticsoftware.elasticactors.tracing.CreationContext;
import org.elasticsoftware.elasticactors.tracing.TraceContext;

public final class TransientInternalMessage
extends AbstractTracedMessage
implements InternalMessage,
Serializable,
Splittable<String, InternalMessage> {
    private final ActorRef sender;
    private final ImmutableList<ActorRef> receivers;
    private final UUID id;
    private final Object payload;
    private final String messageQueueAffinityKey;
    private final boolean undeliverable;

    public TransientInternalMessage(ActorRef sender, ImmutableList<ActorRef> receivers, Object payload) {
        this(sender, receivers, payload, false);
    }

    public TransientInternalMessage(ActorRef sender, ActorRef receiver, Object payload, boolean undeliverable) {
        this(sender, (ImmutableList<ActorRef>)ImmutableList.of((Object)receiver), payload, undeliverable);
    }

    private TransientInternalMessage(ActorRef sender, ImmutableList<ActorRef> receivers, Object payload, boolean undeliverable) {
        this.sender = sender;
        this.receivers = receivers;
        this.id = UUIDTools.createTimeBasedUUID();
        this.payload = payload;
        this.undeliverable = undeliverable;
        this.messageQueueAffinityKey = InternalHashKeyUtils.getMessageQueueAffinityKey(payload);
    }

    public TransientInternalMessage(ActorRef sender, ImmutableList<ActorRef> receivers, Object payload, boolean undeliverable, TraceContext traceContext, CreationContext creationContext) {
        super(traceContext, creationContext);
        this.sender = sender;
        this.receivers = receivers;
        this.id = UUIDTools.createTimeBasedUUID();
        this.payload = payload;
        this.undeliverable = undeliverable;
        this.messageQueueAffinityKey = InternalHashKeyUtils.getMessageQueueAffinityKey(payload);
    }

    @Nullable
    public ActorRef getSender() {
        return this.sender;
    }

    public String getTypeAsString() {
        return this.payload.getClass().getName();
    }

    @Nullable
    public Class<?> getType() {
        return this.payload.getClass();
    }

    public ImmutableList<ActorRef> getReceivers() {
        return this.receivers;
    }

    public UUID getId() {
        return this.id;
    }

    public ByteBuffer getPayload() {
        throw new UnsupportedOperationException(String.format("This implementation is intended to be used local only, for remote use [%s]", DefaultInternalMessage.class.getSimpleName()));
    }

    public <T> T getPayload(MessageDeserializer<T> deserializer) {
        return (T)this.payload;
    }

    public String getPayloadClass() {
        return this.payload.getClass().getName();
    }

    public boolean isDurable() {
        return false;
    }

    public boolean isUndeliverable() {
        return this.undeliverable;
    }

    public int getTimeout() {
        return -1;
    }

    public boolean hasSerializedPayload() {
        return false;
    }

    public boolean hasPayloadObject() {
        return this.payload != null;
    }

    @Nullable
    public String getMessageQueueAffinityKey() {
        if (this.messageQueueAffinityKey != null) {
            return this.messageQueueAffinityKey;
        }
        return this.receivers.size() == 1 ? ((ActorRef)this.receivers.get(0)).getActorId() : null;
    }

    public byte[] toByteArray() {
        throw new UnsupportedOperationException(String.format("This implementation is intended to be used local only, for remote use [%s]", DefaultInternalMessage.class.getSimpleName()));
    }

    public InternalMessage copyOf() {
        return this;
    }

    @Override
    public ImmutableMap<Integer, InternalMessage> splitInBuckets(Hasher hasher, int buckets) {
        return this.receivers.size() <= 1 ? ImmutableMap.of((Object)SplittableUtils.calculateBucketForEmptyOrSingleActor(this.receivers, hasher, buckets), (Object)this) : SplittableUtils.groupByBucket(this.receivers, hasher, buckets, this::copyForReceivers);
    }

    private InternalMessage copyForReceivers(List<ActorRef> receivers) {
        return new TransientInternalMessage(this.sender, (ImmutableList<ActorRef>)ImmutableList.copyOf(receivers), this.payload, this.undeliverable, this.getTraceContext(), this.getCreationContext());
    }
}

